def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer object and a gripper
        drawer = 'middle'  # Example drawer name
        gripper = 'gripper'  # Example gripper name
        current_position = 'initial_position'  # Replace with actual initial position

        # Step 1: Move to the side position of the drawer
        side_position = 'side_position'  # Replace with actual side position
        print(f"[Task] Moving {gripper} to side position: {side_position}")
        obs, reward, done = move(env, gripper, current_position, side_position)
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 2: Rotate the gripper to the correct angle
        print(f"[Task] Rotating {gripper} to ninety degrees.")
        obs, reward, done = rotate(env, gripper, 'zero_deg', 'ninety_deg')
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 3: Move to the anchor position of the drawer
        anchor_position = 'anchor_position'  # Replace with actual anchor position
        print(f"[Task] Moving {gripper} to anchor position: {anchor_position}")
        obs, reward, done = move_to_anchor(env, gripper, drawer, side_position, anchor_position)
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # Step 4: Pick the drawer
        print(f"[Task] Picking the drawer: {drawer}")
        obs, reward, done = pick(env, gripper, drawer, anchor_position)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 5: Pull the drawer
        print(f"[Task] Pulling the drawer: {drawer}")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()