def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define the drawer and gripper
        drawer = 'bottom'  # Example drawer
        gripper = 'gripper'  # Example gripper

        # Check if the target drawer is in the cabinet
        if drawer not in positions:
            print(f"Error: Target drawer '{drawer}' not found in the cabinet.")
            return

        # Check if the drawer is open or closed
        if not obs.is_open(drawer):
            print(f"Drawer '{drawer}' is closed. Attempting to open it.")
            # Rotate the gripper to the correct position
            target_quat = [0, 0, 0, 1]  # Example quaternion for rotation
            obs = rotate(env, task, target_quat)

            # Move to the side position
            side_pos = positions[drawer]['side']
            obs = move(env, gripper, obs.position, side_pos)

            # Move to the anchor position
            anchor_pos = positions[drawer]['anchor']
            obs = move(env, gripper, side_pos, anchor_pos)

            # Pick the drawer
            obs = pick(env, gripper, drawer, anchor_pos)

        # Pull the drawer to open it
        obs = pull(env, gripper, drawer)

        print("Task completed successfully.")

    except Exception as e:
        print(f"An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()