def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer object and its position
        drawer_pos = positions['drawer']  # Replace with actual drawer object key
        gripper_pos = positions['gripper']  # Replace with actual gripper object key

        # Check if the drawer is identified and not locked
        if not obs.is_locked(drawer_pos):
            # Move to the drawer position
            print("[Task] Moving to drawer position:", drawer_pos)
            obs, reward, done = move(env, task, target_pos=drawer_pos)
            if done:
                print("[Task] Task ended while moving to drawer!")
                return

            # Attempt to pick the drawer
            print("[Task] Picking the drawer at:", drawer_pos)
            obs, reward, done = pick(env, drawer_pos, gripper_pos)
            if done:
                print("[Task] Task ended while picking the drawer!")
                return

            # Pull the drawer to open it
            print("[Task] Pulling the drawer to open it.")
            obs, reward, done = pull(env, drawer_pos)
            if done:
                print("[Task] Task ended while pulling the drawer!")
                return

        else:
            print("[Task] The drawer is locked, cannot proceed.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()