def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming drawer1 is the object we want to manipulate
        drawer1_pos = positions['drawer1']  # Replace with actual drawer object name

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to the side position of drawer1.")
        obs, reward, done = move(env, 'gripper', 'current_position', 'side_position')  # Replace with actual positions
        if done:
            print("[Task] Task ended after moving to side position!")
            return

        # Step 2: Rotate the gripper to the correct angle
        print("[Task] Rotating gripper to ninety degrees.")
        obs, reward, done = rotate(env, task, target_quat=[0, 0, 1, 0])  # Replace with actual quaternion for ninety degrees
        if done:
            print("[Task] Task ended after rotating gripper!")
            return

        # Step 3: Move to the anchor position of the drawer
        print("[Task] Moving to the anchor position of drawer1.")
        obs, reward, done = move(env, 'gripper', 'side_position', 'anchor_position')  # Replace with actual positions
        if done:
            print("[Task] Task ended after moving to anchor position!")
            return

        # Step 4: Pick the drawer
        print("[Task] Picking drawer1.")
        obs, reward, done = pick(env, 'gripper', 'drawer1', 'anchor_position')  # Replace with actual drawer name and position
        if done:
            print("[Task] Task ended after picking drawer!")
            return

        # Step 5: Pull the drawer
        print("[Task] Pulling drawer1.")
        obs, reward, done = pull(env, 'gripper', 'drawer1')  # Replace with actual drawer name
        if done:
            print("[Task] Task ended after pulling drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()