import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  # Importing skill functions (pick, pull, etc.)
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Initializing parameters for specific drawer positions
        bottom_anchor_pos = positions['bottom_anchor_pos']

        # === Execute the Plan ===
        # Step 1: Pick the bottom drawer
        print("[Task] Picking the bottom drawer...")
        obs, reward, done = pick(env, task, target_pos=bottom_anchor_pos, approach_distance=0.15)
        if done:
            print("[Task] Task ended after picking the bottom drawer!")
            return

        # Step 2: Pull the bottom drawer to open it
        print("[Task] Pulling the bottom drawer...")
        obs, reward, done = pull(env, task, pull_distance=0.3)  # Adjust distance as necessary
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()