def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a single object to pick and a location to place it
        object_pos = positions['object_1']  # Replace with actual object key
        drop_location = positions['drop_zone']  # Replace with actual drop zone key

        # 1) Move to the object's location
        print("[Task] Moving to object location:", object_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to object location!")
            return

        # 2) Pick the object
        print("[Task] Picking up the object at:", object_pos)
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # 3) Move to the drop location
        print("[Task] Moving to drop location:", drop_location)
        obs, reward, done = move(env, 'room_b', 'room_c')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # 4) Place the object
        print("[Task] Placing the object at:", drop_location)
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()