def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named as follows based on the provided PDDL
        rubbish_pos = positions['rubbish']
        table_pos = positions['table']

        # Check if the rubbish object exists in the environment
        if 'rubbish' not in positions:
            print("Object 'rubbish' not found in the environment.")
            return

        # Check if the rubbish object is in the table location
        if rubbish_pos != table_pos:
            print("Object 'rubbish' is not in the table location.")
            return

        # Step 1: Move to the table location
        print("[Task] Moving to the table location.")
        obs, reward, done = move(env, 'robot', 'current_location', 'table')
        if done:
            print("[Task] Task ended after moving to the table!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # Step 3: Place the rubbish in the bin (assuming bin position is known)
        bin_pos = positions['bin']
        print("[Task] Moving to the bin location.")
        obs, reward, done = move(env, 'robot', 'table', 'bin')
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing the rubbish in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()