def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick up
        rubbish_pos = positions['rubbish']  # Replace 'rubbish' with the actual object key

        # Step 1: Move to the location of the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'current_room', 'rubbish_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the disposal location
        disposal_pos = positions['disposal']  # Replace 'disposal' with the actual disposal location key
        print("[Task] Moving to disposal at:", disposal_pos)
        obs, reward, done = move(env, 'rubbish_room', 'disposal_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to disposal!")
            return

        # Step 4: Place the rubbish in the disposal location
        print("[Task] Placing rubbish at disposal location:", disposal_pos)
        obs, reward, done = place(env, task, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()