def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a 'rubbish' object and a 'bin' location
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 4: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, task, bin_pos, 'rubbish')
        if done:
            print("[Task] Task ended after placing rubbish in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()