def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming 'rubbish' is the object we want to pick
        rubbish_pos = positions.get('rubbish')
        if rubbish_pos is None:
            print("Error: Object 'rubbish' not found in environment.")
            return

        # Move to the location of the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, 'rooma', 'roomb')  # Example rooms, adjust as necessary
        if done:
            print("[Task] Task ended during movement!")
            return

        # Pick the rubbish
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # Place the rubbish in a designated location (e.g., 'bin')
        bin_pos = positions.get('bin')  # Assuming 'bin' is the location to place rubbish
        if bin_pos is None:
            print("Error: Bin location not found in environment.")
            return

        print("[Task] Placing rubbish in bin at:", bin_pos)
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()