def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        rubbish_pos = positions['rubbish']  # Assuming 'rubbish' is now included in the object list

        # Step 1: Move to the location of rubbish
        print("[Task] Moving to rubbish location:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish location!")
            return

        # Step 2: Pick up the rubbish
        print("[Task] Picking up rubbish at:", rubbish_pos)
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Move to the disposal location (assuming a predefined disposal position)
        disposal_pos = positions['disposal']  # Assuming 'disposal' is a valid location
        print("[Task] Moving to disposal location:", disposal_pos)
        obs, reward, done = move(env, task, obs.robot_position, disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # Step 4: Place the rubbish in the disposal location
        print("[Task] Placing rubbish at disposal location:", disposal_pos)
        obs, reward, done = place(env, task, target_pos=disposal_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()