import subprocess
import os

def run_fast_downward(domain_file, problem_file):
    current_dir = "Input_Your_Path"
    fast_downward_path = os.path.join(current_dir, "downward", "fast-downward.py")
    
    if not os.path.exists(fast_downward_path):
        print(f"Error: '{fast_downward_path}' does not exist.")
        return
    
    command = (
        f"{fast_downward_path} --alias seq-sat-lama-2011 "
        f"--plan-file {os.path.join(current_dir, 'sas_plan')} "
        f"{domain_file} {problem_file}"
    )
    
    result = subprocess.run(command, shell=True, capture_output=True, text=True)
    
    if result.returncode != 0:
        print("Error:", result.stderr)
        return
    
    plan_file = os.path.join(current_dir, "sas_plan")
    if os.path.exists(plan_file):
        with open(plan_file, "r") as file:
            plan = file.read()
        print("Generated Plan:\n", plan)
    else:
        print("Plan file was not generated.")