from .confidence.confidence_csc import compute_llm_score_and_feedback
from .confidence.confidence_lc import check_skill_pddl

def print_validation_result(success: bool, title: str):
    line_width = 60

    PURPLE = "\033[95m"
    GREEN = "\033[92m"
    RED = "\033[91m"
    RESET = "\033[0m"

    print(PURPLE + "=" * line_width + RESET)
    print(title.center(line_width))
    print(PURPLE + "=" * line_width + RESET)

    result_msg = "Result: PASS" if success else "Result: FAIL"
    color = GREEN if success else RED
    print((color + result_msg + RESET).center(line_width))

    print(PURPLE + "=" * line_width + RESET)

def validate_skill(
    target_skill_def_code,
    target_skill_call_code,
    domain_pddl,
    base_path,
    init_observation,
    skill_name,
    rag_demos,
    instruction,
    object_list,
    validation_mode: str = "both",
    threshold: float = -0.5,
):
    print(f"Validation mode: {validation_mode}")

    if validation_mode in {"both", "csc"}:
        llm_score, csc_feedback = compute_llm_score_and_feedback(
            rag_demos,
            init_observation,
            target_skill_def_code,
            instruction,
            object_list,
            threshold,
        )
        csc_pass = (llm_score is not None) and (llm_score >= threshold)
        print_validation_result(csc_pass, "Validation CSC")
    else:
        llm_score = None
        csc_feedback = "CSC check skipped (validation_mode='lc')."
        csc_pass = True

    if validation_mode in {"both", "lc"}:
        confidence, lc_feedback, problem_pddl = check_skill_pddl(
            target_skill_def_code,
            target_skill_call_code,
            domain_pddl,
            "Input_Your_Path",
            init_observation,
            skill_name,
        )
        lc_pass = confidence == 1
        print_validation_result(confidence == 1, "Validation LC")
    else:
        confidence = None
        lc_feedback = "LC check skipped (validation_mode='csc')."
        problem_pddl = None
        lc_pass = True

    exploration_needed = False
    updated_observation = init_observation
    if not (csc_pass and lc_pass):
        exploration_needed = True
        updated_observation = "(:objects ... )\n\n(:init ... )"

    return (
        csc_pass,
        lc_pass,
        updated_observation,
        csc_feedback,
        lc_feedback,
        exploration_needed,
        llm_score,
        confidence,
    )