#!/bin/bash

# Check for correct number of arguments
if [ "$#" -ne 4 ]; then
    echo "Usage: $0 index_file org_dir syn_dir output_dir"
    exit 1
fi

# Assign arguments to variables
INDEX_FILE=$1
ORG_DIR=$2
SYN_DIR=$3
OUTPUT_DIR=$4

# Run Python script to select images
python select_images.py --index_file "$INDEX_FILE" --org_dir "$ORG_DIR" --syn_dir "$SYN_DIR" --output_dir "$OUTPUT_DIR"

# Calculate FID
python -m pytorch_fid "$OUTPUT_DIR/org" "$OUTPUT_DIR/syn"
