## Environment
From the top-level directory execute:
```sh
conda env create -n sam_up -f config.yaml
conda activate sam_up
pip install -r requirements.txt
```

## Usage

Input/output directories are always defined by the combination of an experiment name `exp_name` and a run name `run_name`. Multiple runs can belong to a single experiment. These parameters organize the creation of new runs (in the case of `training`) as well as direct scripts to add additional examples to existing runs in the local directory path `team_path` (set in `global_params.yaml`). `exp_name` also localizes runs by project in wandb and `run_name` also specifies wandb run names in addition to local directory paths.

### Training

- Primary script to launch training runs. A full list of accepted script arguments can be found in `training/train_params.yaml`.

### Examples

```python
cd training/sh/resnet18
./cifar10_syn.sh
```
