# Generate Synthetic Data for Data Augmentation


## Getting started

Install dependencies:

```sh
conda create -n SyntheticData python=3.7
conda activate SyntheticData
pip install -r requirements.txt
```

## Synthetic data 

```sh
sh glide/gen_fsl.sh dataset /path/to/images /path/to/save/generate_dataset
```

## Calulate FID

```sh
sh calculate_fid/cal_fid.sh /path/to/indices_tensor /path/to/images /path/to/synthetic/images /path/to/save/selected/images
```

## Mix Synthetic data and Original data
To ensure the synthetic images are the same size as the original images, we need to set target_size to the size of the original images, e.g. (32, 32) for CIFAR10.
```sh
python mix.py /path/to/original_images /path/to/save/resized_images target_size /path/to/indices_tensor /path/to/save/mixed_images
```


## Acknowledgement

We thank the open source code from [GLIDE](https://github.com/openai/glide-text2im), [SyntheticData](https://github.com/CVMI-Lab/SyntheticData).
