#!/bin/bash

CURR_DIR=$(cd $(dirname "$0") && pwd)
RUN_DIR="$CURR_DIR/../../train.py"
SEED=0
CLUSTERS=2
CLUSTER_INDICES=1
SHUFFLE=false
MODEL=resnet18
AUGM=none
LR=0.1
RHO=0.0 # 0.1 for SAM
LIST_EPOCH=(
    8
)
LIST_GPU=(
    0
)

for i in "${!LIST_EPOCH[@]}"; do
    (EPOCH="${LIST_EPOCH[i]}"
    gpu="${LIST_GPU[i]}"
    python $RUN_DIR \
        exp_name=ResNet18 \
        run_name=cifar10_erm_syn_${MODEL}_lr${LR}_epoch${EPOCH}_${CLUSTERS}cls_${CLUSTER_INDICES}_shuffle${SHUFFLE}_seed${SEED} \
        \
        model=$MODEL \
        dataset=cifar10 \
        \
        eval_model_every_k_epochs=1 \
        lr_max=$LR \
        \
        sam_rho=$RHO \
        \
        get_fs_stats=true \
        \
        aus=true \
        aus_epochs=$EPOCH \
        aus_method=clustering \
        aus_score=grad_norm \
        aus_clusters=$CLUSTERS \
        upsample_cluster_indices=[$CLUSTER_INDICES] \
        aus_cluster_by=activations \
        aus_shuffle_after=$SHUFFLE \
        \
        us_type=syn \
        us_syn_dataset=syn_cifar10_steps_40_50_70_80 \
        \
        seed=$SEED \
        gpu=$gpu ) &
done
