#!/bin/bash

# cd ../..

# custom config
DATA=/PATH
TRAINER=$4 
# CoCoOp
# TRAINER=CoOp

DATASET=$1
SEED=$2
SHOTS=$3
GPU=$5
CFG=vit_b16_c4_ep10_batch1_ctxv1
CFG=vit_imagenet
# CFG=vit_b16_ctxv1  # uncomment this when TRAINER=CoOp

LOADEP=2
SUB=new


COMMON_DIR=${DATASET}/shots_${SHOTS}/${TRAINER}/${CFG}/seed${SEED}
MODEL_DIR=output/base2new/train_base/${COMMON_DIR}
DIR=output/base2new/test_${SUB}/${COMMON_DIR}

CUDA_VISIBLE_DEVICES=${GPU} python train.py \
--root ${DATA} \
--seed ${SEED} \
--trainer ${TRAINER} \
--dataset-config-file configs/datasets/${DATASET}.yaml \
--config-file configs/trainers/${TRAINER}/${CFG}.yaml \
--output-dir ${DIR} \
--model-dir ${MODEL_DIR} \
--load-epoch ${LOADEP} \
--eval-only \
DATASET.NUM_SHOTS ${SHOTS} \
DATASET.SUBSAMPLE_CLASSES ${SUB}
