import numpy as np
import pdb

def plot_loss(fname):
	print ('name:', fname)
	train_losses = []
	val_losses = []
	nnz_userT = []
	nnz_itemT = []
	total_nnz = []
	user_as = []
	item_as = []
	overall_losses = []
	with open(fname) as f:
		lines = f.readlines()
		for line in lines:
			line = line.strip()
			if 'it/s' in line:
				continue
			if 'Training loss' in line:
				train_losses.append(float(line.split(' ')[-1]))
			if 'Val loss' in line:
				val_losses.append(float(line.split(' ')[-1]))
			if 'nnz in user T' in line:
				nnz_userT.append(int(line.split(' ')[-1]))
			if 'nnz in item T' in line:
				nnz_itemT.append(int(line.split(' ')[-1]))
			if 'total nnz params' in line:
				total_nnz.append(int(line.split(' ')[-1]))
			if 'Num anchors users' in line:
				user_as.append(int(line.split(' ')[3][:-1]))
				item_as.append(int(line.split(' ')[5][:-1]))
			if 'Overall loss' in line:
				overall_losses.append(float(line.split(' ')[-1]))


	print ('nnz_userT:', nnz_userT[-10:])
	print ()
	print ('nnz_itemT:', nnz_itemT[-10:])
	print ()
	print ('total_nnz:', total_nnz[-10:])
	print ()
	print ('user_as:', user_as) #[-10:])
	print ()
	print ('item_as:', item_as) #[-10:])
	print ()
	print ('train_losses:', train_losses[-10:])
	print ()
	print ('val_losses:', val_losses) #[-10:])
	print ()
	print ('overall_losses:', overall_losses) #[-10:])
	print ()
	return

	for (ua,ia,ov) in zip(user_as,item_as,overall_losses):
		print (ov, ua, ia)

	lda1 = 0.01
	lda2 = 2e-06
	total_nnz = np.array(total_nnz[22:1150:23])
	val_losses = np.array(val_losses)
	user_as = np.array(user_as)
	item_as = np.array(item_as)
	total_loss = 2*val_losses + lda2*total_nnz + (lda1-lda2)*(user_as+item_as)
	return
	# pdb.set_trace()

# plot_loss('res_25m/MF_dim16.txt')
# plot_loss('res_25m/MF_dim16_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.000001_f20_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia100_0.000001_f20_split0.9.txt')
# plot_loss('res_25m/sparse_ua50_ia50_0.000002_f10.txt')
# plot_loss('res_25m/sparse_ua50_ia50_0.000001_f10.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.000002_f10_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.000001_f10_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0000001_f10_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0000005_f10_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0000001_f20_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0000005_f20_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0_split0.9.txt')
# plot_loss('res_25m/sparse_ua100_ia100_0.0_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0_split0.9_s2.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0_split0.9_s3.txt')

# plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_lda2e0.000005_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_lda2e0.00001_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_lda2e0.00002_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_lda2e0.00005_dim16.txt')

'''
plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_zerofor5_lda2e0.000005_dim32.txt')
plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_zerofor5_lda2e0.00001_dim32.txt')
plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_zerofor5_lda2e0.00002_dim32.txt')
plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_zerofor5_lda2e0.00005_dim32.txt')

plot_loss('res_25m/sparseMF_ua10_ia10_lda2s0.0_zerofor5_lda2e0.000005_dim16.txt')
plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_zerofor5_lda2e0.00001_dim16.txt')
plot_loss('res_25m/sparseMF_ua50_ia50_lda2s0.0_zerofor5_lda2e0.00002_dim16.txt')
plot_loss('res_25m/sparseMF_ua50_ia100_lda2s0.0_zerofor5_lda2e0.00002_dim16.txt')
'''
# plot_loss('res_25m/dynamic1.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda2s0.0_zerofor5_lda2e0.00001_dim16_v2.txt')

# plot_loss('res_25m/mf.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.0_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.0000005_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.0000008_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.000001_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.0000005_dim32.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.0000008_dim32.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.000001_dim32.txt')


plot_loss('res_1m/bs32.txt')
plot_loss('res_1m/bs128.txt')
plot_loss('res_1m/bs256.txt')
plot_loss('res_1m/md16_t0.4_k8.txt')
plot_loss('res_1m/md16_t0.4_k16.txt')
plot_loss('res_1m/md16_t0.6_k8.txt')
plot_loss('res_1m/md16_t0.6_k16.txt')
plot_loss('res_1m/md32_t0.6_k8.txt')
plot_loss('res_1m/md32_t0.6_k16.txt')

# plot_loss('res_25m/dynamic_0.01_0.000001.txt')
# plot_loss('res_25m/dynamic_0.01_0.000002.txt')		# ***
# plot_loss('res_25m/dynamic_0.01_0.000003.txt')
# plot_loss('res_25m/dynamic_0.01_0.000004.txt')
# plot_loss('res_25m/dynamic_0.01_0.000005.txt')

# plot_loss('res_25m/dynamic_0.1_0.000002_v2.txt')		# ***
# plot_loss('res_25m/dynamic_0.1_0.000003_v2.txt')
# plot_loss('res_25m/dynamic_0.01_0.000002_v2.txt')		# ***
# plot_loss('res_25m/dynamic_0.01_0.000003_v2.txt')

# plot_loss('res_25m/dynamic_0.01_0.000008.txt')
# plot_loss('res_25m/dynamic_0.01_0.00001.txt')

# plot_loss('res_25m/dynamic_0.01_0.000001.txt')
# plot_loss('res_25m/dynamic_0.05_0.000001.txt')
# plot_loss('res_25m/dynamic_0.1_0.000001.txt')

# plot_loss('res_25m/dynamic_0.05_0.0000005.txt')
# plot_loss('res_25m/dynamic_0.1_0.0000005.txt')

# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.000001_dim16_init.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.000005_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.00001_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.00002_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.00005_dim16.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.000001_dim16_lr0.1.txt')
# plot_loss('res_25m/sparseMF_ua20_ia20_lda20.000002_dim16_lr0.1.txt')


# plot_loss('res_25m/sparse_ua20_ia100_0.0000005_f10_s200000_g0.5_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0000005_f10_s200000_g0.5_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia20_0.0000005_f20_s200000_g0.5_split0.9.txt')
# plot_loss('res_25m/sparse_ua20_ia100_0.0000005_f20_s200000_g0.5_split0.9.txt')
