from abc import abstractmethod
from typing import Dict, List, Set
from game import Game, S_
from mytypes import NumExpr

class GameWithTransitions(Game[S_]):

    @abstractmethod
    def all_states(self) -> Set[S_]:
        raise NotImplementedError

    @abstractmethod
    def transition(self, state: S_, actions: List[int]) -> Dict[S_, NumExpr]:
        raise NotImplementedError