# TS-RaMIA Paper - AAAI EAIM 2026

**Title**: TS-RaMIA: Time- and Structure-Range Membership Inference Attacks for Symbolic Music Generation Models

**Status**: Draft in progress

---

## Structure

```
paper/
├── main.tex                    # Main LaTeX file with global macros
├── sections/                   # Individual section files
│   ├── abstract.tex
│   ├── introduction.tex
│   ├── background.tex
│   ├── threat_model.tex
│   ├── method.tex             # Core TS-RaMIA methodology
│   ├── experimental_setup.tex
│   ├── results.tex            # Main results
│   ├── notagen.tex            # Cross-representation study (PROVISIONAL)
│   ├── ablations.tex
│   ├── discussion.tex
│   ├── ethics.tex
│   ├── limitations.tex
│   ├── conclusion.tex
│   ├── reproducibility.tex
│   └── appendix.tex
├── tab/                        # Tables
│   ├── main_results.tex
│   ├── ablations.tex
│   └── notagen_results.tex    # PROVISIONAL
├── fig/                        # Figures (placeholders for now)
│   ├── tsramia_framework.pdf  # TODO: Create pipeline diagram
│   ├── roc_main.png           # From results/protocol_randomized/
│   ├── roc_lowfpr.png         # From reports/
│   └── ckpt_auc_curve.png     # From reports/
├── references.bib              # Bibliography
└── README.md                   # This file
```

---

## Key Results (Macros in main.tex)

### Model A (REMI Transformer, 67M params)
- **AUC**: 0.826 (95% CI: [0.798, 0.854])
- **TPR@1%FPR**: 14.6%
- **TPR@5%FPR**: 38.0%
- **TPR@10%FPR**: 52.6%
- **Debiased Baseline AUC**: 0.563

### NotaGen (ABC, 109.6M params) - PROVISIONAL
- **AUC**: 0.81 (estimated)
- **TPR@1%FPR**: 12-15% (estimated)
- **Status**: Experiments in progress, replace after completion

---

## Compilation

### Requirements
- LaTeX distribution (TeX Live, MiKTeX, etc.)
- Packages: `pmlr`, `natbib`, `booktabs`, `amsmath`, `todonotes`, etc.

### Compile
```bash
cd /home/yons/文档/AAAI/paper
pdflatex main.tex
bibtex main
pdflatex main.tex
pdflatex main.tex
```

Or use the provided script:
```bash
bash compile.sh
```

---

## TODO Before Submission

### Figures
- [ ] Create `fig/tsramia_framework.pdf` (pipeline diagram)
- [ ] Copy `reports/roc_main.png` to `fig/`
- [ ] Copy `reports/roc_lowfpr.png` to `fig/`
- [ ] Copy `reports/ckpt_scan_curves_AUC.png` to `fig/ckpt_auc_curve.png`

### NotaGen (PROVISIONAL)
- [ ] Run NotaGen experiments (NG-2.6)
- [ ] Replace `\aucNotaGen` and `\tprNotaGen` macros in `main.tex`
- [ ] Update `tab/notagen_results.tex` with exact numbers
- [ ] Remove all `% TODO(NotaGen)` comments

### Final Checks
- [ ] Remove `\usepackage{todonotes}` for final submission
- [ ] Check all citations are in `references.bib`
- [ ] Verify all figure/table references resolve
- [ ] Word count within AAAI Workshop limits (typically 8 pages PMLR)
- [ ] Anonymize for review (remove author names/affiliations)

---

## Citation Placeholders

Some citations may need to be verified or updated:
- `\citep{notagen}`: NotaGen official paper (if published)
- `\citep{miditok}`: MIDITok library (check if formal publication exists)
- `\citep{abcnotation}`: ABC notation standard (use official URL)

---

## Notes

- All numbers are stored as macros in `main.tex` for easy updates
- Provisional NotaGen content is clearly marked with `% TODO(NotaGen)`
- Debiasing protocol is emphasized throughout (length matching + conditional calibration)
- Low-FPR metrics (TPR@1%FPR) are highlighted as key contributions

---

## Contact

For questions about experimental results or methodology, refer to:
- Main results: `reports/T55_meta_attacker_summary.md`
- NotaGen status: `NotaGen/tasks/NG_A_EXECUTION_REPORT.md`

