#!/bin/bash
# Compile TS-RaMIA paper

echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "Compiling TS-RaMIA Paper"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

# First pass
echo "Pass 1: pdflatex..."
pdflatex -interaction=nonstopmode main.tex > compile.log 2>&1

# Bibliography
echo "Pass 2: bibtex..."
bibtex main >> compile.log 2>&1

# Second pass for references
echo "Pass 3: pdflatex..."
pdflatex -interaction=nonstopmode main.tex >> compile.log 2>&1

# Third pass for final resolution
echo "Pass 4: pdflatex..."
pdflatex -interaction=nonstopmode main.tex >> compile.log 2>&1

echo ""
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"
echo "Compilation complete!"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

# Check if PDF was generated
if [ -f main.pdf ]; then
    echo "✅ PDF generated: main.pdf"
    echo ""
    
    # Show warnings
    echo "Warnings/Errors (if any):"
    grep -i "warning\|error\|undefined" compile.log | head -20
    
    echo ""
    echo "View PDF: evince main.pdf &"
else
    echo "❌ PDF generation failed. Check compile.log for details."
    tail -50 compile.log
fi

echo ""
echo "Full log: compile.log"
echo "━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━"

