# Figure 1: TS-RaMIA Pipeline 详细绘图设计指南

**目标**: 一张清晰、专业的 pipeline 图，展示 TS-RaMIA 的核心流程  
**风格**: ICML/NeurIPS/AAAI 顶会风格 (简洁、学术、信息密度高)  
**工具推荐**: 
- **首选**: TikZ (LaTeX) - 矢量图，可直接嵌入论文
- **备选**: draw.io / Figma / Adobe Illustrator
- **快速原型**: PowerPoint + 导出 PDF

---

## 📐 整体布局设计

### 布局类型: 横向流水线 (Left-to-Right Pipeline)

```
输入 → Stage 1 → Stage 2 → Stage 3 → Stage 4 → 输出
(MIDI)  (Masking)  (Scoring)  (Debiasing)  (Fusion)  (Decision)
```

**尺寸建议**:
- **宽度**: 18cm (双栏论文占满一栏)
- **高度**: 8-10cm
- **长宽比**: ~2:1 (横向)

---

## 🎨 配色方案 (Color Palette)

遵循顶会论文配色原则: 
- ✅ 色盲友好 (避免红绿对比)
- ✅ 灰度打印可区分
- ✅ 学术专业感

### 推荐配色

```
主色调:
- 深蓝色 (Primary):   #2E5090  RGB(46, 80, 144)   - 框架主体
- 橙色 (Accent):      #E8743B  RGB(232, 116, 59)  - 强调关键步骤
- 绿色 (Success):     #19A979  RGB(25, 169, 121)  - 正向信号/member
- 紫色 (Secondary):   #8B5A9E  RGB(139, 90, 158)  - 辅助信号/reverse

中性色:
- 深灰色 (Text):      #2C3E50  - 文字
- 浅灰色 (Background): #ECF0F1  - 背景框
- 白色 (Canvas):      #FFFFFF  - 画布

红色 (Negative):     #C0392B  RGB(192, 57, 43)  - 非成员/警告
```

### 色彩使用规则

1. **Structural tokens (关键!)** → 橙色 (#E8743B)
2. **Member 数据** → 绿色 (#19A979)
3. **Non-member 数据** → 红色 (#C0392B)
4. **Forward direction** → 蓝色 (#2E5090)
5. **Reverse direction** → 紫色 (#8B5A9E)
6. **框架/容器** → 深灰色边框 + 浅灰色背景

---

## 📊 Pipeline 详细设计 (5 个阶段)

### 整体结构

```
┌─────────┐    ┌──────────────┐    ┌──────────────┐    ┌──────────────┐    ┌──────────────┐    ┌─────────┐
│ Input   │───→│  Stage 1:    │───→│  Stage 2:    │───→│  Stage 3:    │───→│  Stage 4:    │───→│ Output  │
│ (MIDI)  │    │  Structural  │    │  Tail-of-    │    │  Rigorous    │    │  Meta-       │    │ (Score) │
│         │    │  Masking     │    │  Loss        │    │  Debiasing   │    │  Fusion      │    │         │
└─────────┘    └──────────────┘    └──────────────┘    └──────────────┘    └──────────────┘    └─────────┘
```

---

### Stage 0: Input (输入)

**位置**: 最左侧  
**尺寸**: 2cm × 2cm (正方形图标)

#### 视觉元素

```
┌──────────────┐
│   🎼 MIDI    │
│   Sequence   │
│              │
│  ♪ ♪ ♫ ♩ ♪  │  ← 简化的音符符号
│              │
│  T=1024      │  ← 序列长度标注
└──────────────┘
```

**设计细节**:
1. **图标**: 简化的五线谱 + 音符 (黑色线条)
2. **标签**: "MIDI Sequence" (粗体)
3. **子标签**: "T=1024 tokens" (小字)
4. **背景**: 白色
5. **边框**: 深灰色细线 (1pt)

#### TikZ 代码示例

```latex
\node[draw, thick, minimum width=2cm, minimum height=2cm, align=center] (input) {
  \textbf{MIDI Sequence} \\[0.2cm]
  {\small \musNote\ \musNote\ \musNote\ \musNote} \\[0.1cm]
  {\footnotesize $T=1024$}
};
```

---

### Stage 1: Structural Masking (结构掩码)

**位置**: 第一个处理阶段  
**尺寸**: 3.5cm × 8cm (竖直长方形)

#### 核心思想可视化

展示 **token 序列 → 掩码 → 筛选后的 structural tokens**

#### 视觉元素 (三层结构)

```
┌────────────────────────────────┐
│  Stage 1: Structural Masking  │ ← 标题 (深蓝色背景)
├────────────────────────────────┤
│                                │
│  Input Tokens:                 │
│  [Bar][Pos][Note][Vel][Tempo]  │ ← 混合 tokens (黑色小方块)
│   ↓    ↓    ↓    ↓     ↓      │
│                                │
│  Structural Mask:              │
│  [ ✓ ][ ✓ ][ ✗ ][ ✗ ][ ✓ ]   │ ← 掩码 (橙色 ✓, 灰色 ✗)
│   ↓    ↓          ↓           │
│                                │
│  Filtered Output:              │
│  [Bar][Pos][Tempo]            │ ← 保留的 tokens (橙色方块)
│                                │
│  Ratio: ~15-20%                │ ← 统计信息
└────────────────────────────────┘
```

**设计细节**:

1. **标题栏**:
   - 背景: 深蓝色 (#2E5090)
   - 文字: 白色, 粗体, 12pt
   - 高度: 0.8cm

2. **Token 可视化**:
   - **Input tokens**: 5 个小方块 (0.4cm × 0.4cm)
     - Bar/Position/Tempo: 橙色边框 + 白色填充
     - Note/Velocity: 灰色填充
   - **Mask indicators**: ✓ (橙色) / ✗ (浅灰色)
   - **Filtered output**: 3 个橙色方块 (保留的 structural tokens)

3. **箭头**:
   - 垂直向下箭头 (虚线, 灰色)
   - 连接三层

4. **标注**:
   - "Ratio: ~15-20%" (小字, 底部)
   - 图例: [Bar], [Pos], [Tempo] (橙色), [Note], [Vel] (灰色)

#### 关键标注 (Callout Box)

在右侧添加一个小标注框:

```
┌─────────────────┐
│ Structural      │
│ Tokens:         │
│ • Bar lines     │ ← 橙色圆点
│ • Positions     │
│ • Tempo/Meter   │
└─────────────────┘
```

---

### Stage 2: Tail-of-Loss Aggregation (尾部聚合)

**位置**: 第二个处理阶段  
**尺寸**: 3.5cm × 8cm

#### 核心思想可视化

展示 **NLL 分布 → Top-k 选择 → 聚合**

#### 视觉元素 (三层结构)

```
┌────────────────────────────────┐
│  Stage 2: Tail-of-Loss         │ ← 标题
├────────────────────────────────┤
│                                │
│  Per-token NLL Distribution:   │
│                                │
│    NLL                         │
│     │  ┌─┐                     │ ← 柱状图 (最右侧高亮)
│  10 │  │ │    ┌─┐              │
│   5 │  │ │ ┌─┐│█│              │
│   0 │┌─┼─┼─┼─┼─┤              │
│     └──────────────→ Tokens   │
│                                │
│  Select Top-k (k=64):          │
│  [████████████]  ← k=64       │ ← 高亮区域 (橙色)
│                                │
│  Aggregation:                  │
│  score = mean(NLL_top64)       │ ← 公式
│        = 7.25                  │
└────────────────────────────────┘
```

**设计细节**:

1. **标题栏**: 同 Stage 1

2. **NLL 分布图**:
   - **类型**: 简化的柱状图 (histogram)
   - **X 轴**: Tokens (150 个, 横向)
   - **Y 轴**: NLL 值 (0-10)
   - **配色**:
     - 普通 tokens: 浅蓝色 (#AED6F1)
     - Top-k tokens (最右侧): 橙色 (#E8743B)
   - **尺寸**: 2.5cm × 1.5cm

3. **Top-k 标注**:
   - 箭头指向橙色区域
   - 标签: "Top-64 hardest" (橙色文字)

4. **聚合公式**:
   - LaTeX 格式: $\text{score} = \frac{1}{k}\sum_{i=1}^{k}\text{NLL}_{\text{sorted}}[i]$
   - 示例值: "= 7.25" (绿色, 表示 member 高分)

#### 关键标注 (Callout Box)

```
┌─────────────────┐
│ Why Tail?       │
│                 │
│ Memorization is │
│ sparse & local. │
│ Top-k amplifies │
│ sparse signals. │
└─────────────────┘
```

**位置**: Stage 2 右上角, 虚线箭头指向柱状图的橙色区域

---

### Stage 3: Rigorous Debiasing (严格去偏)

**位置**: 第三个处理阶段  
**尺寸**: 3.5cm × 8cm

#### 核心思想可视化

展示 **原始分数 → 长度匹配 → 条件校准 → 去偏后分数**

#### 视觉元素 (双路径对比)

```
┌────────────────────────────────┐
│  Stage 3: Rigorous Debiasing   │
├────────────────────────────────┤
│                                │
│  Raw Scores (Confounded):      │
│                                │
│  Member:      █████████ 7.8    │ ← 绿色条
│  Non-member:  ████ 4.2         │ ← 红色条
│  Gap: Large (but spurious)     │
│          ↓                     │
│  Length Matching:              │
│  [M1 ↔ NM1] [M2 ↔ NM2] ...    │ ← 配对示意
│          ↓                     │
│  Conditional Calibration:      │
│  Residual = Score - f(length)  │ ← 公式
│          ↓                     │
│  Debiased Scores:              │
│                                │
│  Member:      ████ 4.5         │ ← 绿色条 (缩短)
│  Non-member:  ███ 3.8          │ ← 红色条
│  Gap: Smaller (true signal)    │
└────────────────────────────────┘
```

**设计细节**:

1. **标题栏**: 同 Stage 1

2. **Before/After 对比**:
   - **Raw scores**: 
     - Member: 绿色条 (长, 7.8)
     - Non-member: 红色条 (短, 4.2)
     - Gap 标注: "Large (spurious)" (灰色虚线箭头)
   
   - **Debiased scores**:
     - Member: 绿色条 (缩短, 4.5)
     - Non-member: 红色条 (略短, 3.8)
     - Gap 标注: "Smaller (true)" (实线箭头)

3. **中间步骤**:
   - **Length matching**: 小图标 (M ↔ NM), 灰色方框 + 双向箭头
   - **Calibration formula**: 
     ```
     Residual = Score - β₀ - β₁·log(n_struct) - β₂·event_density
     ```
     (小字, 6pt, 浅灰色背景)

4. **颜色编码**:
   - Member: 绿色 (#19A979)
   - Non-member: 红色 (#C0392B)
   - 混淆因素 (confounders): 黄色警告图标 ⚠

---

### Stage 4: Meta-Fusion (元融合)

**位置**: 第四个处理阶段  
**尺寸**: 3.5cm × 8cm

#### 核心思想可视化

展示 **多特征输入 → 线性融合 → 最终分数**

#### 视觉元素 (多输入单输出)

```
┌────────────────────────────────┐
│  Stage 4: Meta-Fusion          │
├────────────────────────────────┤
│                                │
│  Input Features:               │
│  ┌────────────┐                │
│  │ TIS_top64  │ ───┐          │ ← 蓝色框 (主特征)
│  └────────────┘    │           │
│  ┌────────────┐    │           │
│  │ Win_p95    │ ───┤           │ ← 紫色框 (窗口)
│  └────────────┘    │           │
│  ┌────────────┐    │           │
│  │ Fwd_NLL    │ ───┤ Linear   │
│  └────────────┘    │ Fusion   │
│  ┌────────────┐    │ (LogReg) │
│  │ Rev_NLL    │ ───┤          │
│  └────────────┘    │           │
│  ┌────────────┐    │           │
│  │ ... (9)    │ ───┘          │
│  └────────────┘     ↓          │
│                                │
│  ┌──────────────────────────┐ │
│  │ P(member) = σ(w·x + b)  │ │ ← 公式框
│  └──────────────────────────┘ │
│                                │
│  Composer-Stratified 5-Fold   │ ← 交叉验证标注
└────────────────────────────────┘
```

**设计细节**:

1. **标题栏**: 同 Stage 1

2. **特征输入** (9 个特征框):
   - **主要特征** (TIS_top64): 蓝色框, 加粗边框
   - **辅助特征** (Win_p95, Fwd/Rev NLL): 紫色/灰色框, 细边框
   - **省略表示**: "... (9)" (灰色虚线框)
   - **尺寸**: 1.2cm × 0.4cm 每个

3. **融合器**:
   - **图标**: 漏斗形状 或 圆形节点 (LogReg)
   - **标签**: "Linear Fusion\n(Logistic Regression)"
   - **配色**: 深蓝色 (#2E5090)

4. **输出公式**:
   - LaTeX: $P(\text{member}) = \sigma(\mathbf{w}^\top \mathbf{x} + b)$
   - 背景: 浅蓝色 (#D6EAF8)

5. **交叉验证标注**:
   - 图标: 5 个折叠的小图标 (F1, F2, F3, F4, F5)
   - 标签: "Composer-Stratified 5-Fold CV"
   - 位置: 底部

---

### Stage 5: Output (输出)

**位置**: 最右侧  
**尺寸**: 2cm × 2cm

#### 视觉元素

```
┌──────────────┐
│   Decision   │
│              │
│   P(member)  │
│   = 0.87     │ ← 分数 (绿色, 大字)
│              │
│   ✓ Member   │ ← 判决 (绿色勾)
│              │
│  @1%FPR      │ ← 阈值标注
└──────────────┘
```

**设计细节**:

1. **分数显示**:
   - 数值: "0.87" (绿色, 粗体, 14pt)
   - 标签: "P(member)" (小字)

2. **判决图标**:
   - ✓ (绿色勾, member)
   - 或 ✗ (红色叉, non-member)

3. **阈值标注**:
   - "@1%FPR" (小字, 底部)
   - 虚线指向决策边界

---

## 🔗 连接与箭头设计

### 箭头类型

1. **主流程箭头** (Stage 间):
   - **样式**: 粗实线箭头 (2pt)
   - **颜色**: 深灰色 (#2C3E50)
   - **标签**: 数据流名称 (如 "Masked Tokens", "NLL Scores")

2. **内部流程箭头** (Stage 内):
   - **样式**: 细虚线箭头 (1pt, dashed)
   - **颜色**: 浅灰色 (#95A5A6)

3. **标注箭头** (Callout):
   - **样式**: 细实线 (0.5pt)
   - **颜色**: 橙色 (#E8743B) 或紫色 (#8B5A9E)

### 连接示例

```
Stage 1 ────[Structural Tokens (n~150)]───→ Stage 2
Stage 2 ────[Top-k NLL Scores]────→ Stage 3
Stage 3 ────[Debiased Scores]────→ Stage 4
Stage 4 ────[P(member)]────→ Output
```

**箭头上的标签**:
- 位置: 箭头上方, 居中
- 字体: 小字 (8pt), 斜体
- 颜色: 深灰色

---

## 📝 图例 (Legend)

**位置**: 图的右下角或底部  
**尺寸**: 一行, 紧凑

```
┌─────────────────────────────────────────────────────────────┐
│ Legend:  ■ Member  ■ Non-member  ■ Structural Tokens        │
│          → Forward  ⇢ Reverse    ─ ─ Internal Flow          │
└─────────────────────────────────────────────────────────────┘
```

**图例项**:
1. ■ Member (绿色方块)
2. ■ Non-member (红色方块)
3. ■ Structural Tokens (橙色方块)
4. → Forward (实线箭头)
5. ⇢ Reverse (虚线箭头)
6. ─ ─ Internal Flow (灰色虚线)

---

## 📐 尺寸与间距规范

### 整体尺寸
- **总宽度**: 18cm (双栏论文满宽)
- **总高度**: 9cm
- **Margin**: 0.5cm (四周留白)

### Stage 尺寸
- **宽度**: 3.5cm 每个 Stage
- **高度**: 8cm
- **间距**: 0.3cm (Stage 间)

### 字体规范
- **标题**: 12pt, 粗体, 白色 (标题栏)
- **正文**: 8pt, 常规, 深灰色
- **标注**: 7pt, 斜体, 浅灰色
- **公式**: 8pt, LaTeX 渲染

### 线条规范
- **边框**: 1pt, 深灰色
- **主箭头**: 2pt, 深灰色
- **辅助箭头**: 1pt, 浅灰色虚线
- **标注箭头**: 0.5pt, 橙色/紫色

---

## 🎯 关键设计原则

### 1. 信息层次 (Visual Hierarchy)

```
重要性层级:
1. Pipeline 主流程 (最突出)
   → 粗箭头, 深色, Stage 标题大字
   
2. 核心概念可视化 (次突出)
   → Structural tokens (橙色), Top-k (高亮), Debiasing (对比)
   
3. 技术细节 (辅助)
   → 公式, 参数, 统计数字 (小字, 浅色)
   
4. 标注与图例 (最弱)
   → Callout boxes, Legend (虚线框, 浅灰背景)
```

### 2. 色彩一致性

**全图统一规则**:
- 橙色 (#E8743B) **仅用于** Structural tokens
- 绿色 (#19A979) **仅用于** Member 数据
- 红色 (#C0392B) **仅用于** Non-member 数据
- 蓝色 (#2E5090) **仅用于** Forward / 主框架
- 紫色 (#8B5A9E) **仅用于** Reverse / 辅助信号

### 3. 简洁性 (Simplicity)

❌ **避免**:
- 过多文字 (每个 Stage 不超过 50 字)
- 复杂图表 (柱状图不超过 20 个柱子)
- 3D 效果 (保持 2D 扁平)
- 花哨装饰 (无阴影、渐变、光泽)

✅ **保持**:
- 清晰边界 (所有框都有明确边框)
- 对齐规整 (所有元素水平/垂直对齐)
- 留白充足 (不要挤在一起)

### 4. 可读性 (Readability)

**测试标准**:
- ✅ 缩小到 50% 仍可阅读标题
- ✅ 灰度打印能区分所有元素
- ✅ 色盲模式 (Protanopia/Deuteranopia) 下仍清晰

---

## 🛠️ 分步绘图流程

### Step 1: 绘制画布与网格 (5 分钟)

1. 创建 18cm × 9cm 画布
2. 开启网格 (0.5cm spacing)
3. 添加参考线:
   - 水平: 0.5cm (top margin), 8.5cm (bottom margin)
   - 垂直: 每 3.8cm 一条 (分隔 5 个 Stages)

### Step 2: 绘制主框架 (10 分钟)

1. **Input 框**:
   - 位置: (0.5, 0.5)
   - 尺寸: 2cm × 8cm
   - 样式: 白色背景 + 深灰边框

2. **Stage 1-4 框**:
   - 位置: 从 (2.8, 0.5) 开始, 每个间隔 3.8cm
   - 尺寸: 3.5cm × 8cm 每个
   - 样式: 浅灰背景 (#ECF0F1) + 深灰边框

3. **Output 框**:
   - 位置: (17, 0.5)
   - 尺寸: 2cm × 8cm
   - 样式: 白色背景 + 深灰边框

4. **标题栏**:
   - 每个 Stage 顶部 0.8cm 高
   - 背景: 深蓝色 (#2E5090)
   - 文字: 白色, 粗体, 居中

### Step 3: 填充 Stage 1 (15 分钟)

1. **Input tokens** (5 个小方块):
   ```
   位置: 居中, Y=5.5cm
   尺寸: 0.4cm × 0.4cm, 间隔 0.2cm
   配色:
     - [Bar]: 橙色边框 + 白色填充
     - [Pos]: 橙色边框 + 白色填充
     - [Note]: 灰色填充
     - [Vel]: 灰色填充
     - [Tempo]: 橙色边框 + 白色填充
   ```

2. **Mask indicators** (5 个符号):
   ```
   位置: Y=4cm (Input tokens 下方 1.5cm)
   符号:
     - ✓ (橙色, 14pt) 在 Bar/Pos/Tempo 下方
     - ✗ (浅灰色, 14pt) 在 Note/Vel 下方
   ```

3. **Filtered output** (3 个方块):
   ```
   位置: Y=2.5cm
   尺寸: 0.5cm × 0.5cm, 间隔 0.3cm
   配色: 橙色填充 (#E8743B)
   ```

4. **箭头**:
   - Input → Mask: 垂直虚线, 浅灰色
   - Mask → Output: 垂直虚线, 浅灰色

5. **标注**:
   - "Ratio: ~15-20%" (底部, 小字)
   - Callout box: 右上角, 虚线框

### Step 4: 填充 Stage 2 (20 分钟)

1. **绘制 NLL 分布柱状图**:
   ```
   坐标系:
     - X 轴: 0 → 150 (tokens)
     - Y 轴: 0 → 10 (NLL)
   
   柱子:
     - 总数: 30 个 (简化, 代表 150 个 tokens)
     - 宽度: 0.08cm
     - 间隔: 0.02cm
     - 高度: 随机 (0.5 ~ 8.0), 最右侧 10 个最高
   
   配色:
     - 前 20 个: 浅蓝色 (#AED6F1)
     - 后 10 个: 橙色 (#E8743B) ← Top-k
   ```

2. **Top-k 标注**:
   ```
   箭头: 从 "Top-64" 标签指向橙色柱子区域
   样式: 橙色箭头, 1pt
   ```

3. **聚合公式**:
   ```
   位置: 柱状图下方
   内容: score = mean(NLL_top64) = 7.25
   样式: LaTeX 渲染, 8pt, 浅蓝色背景框
   ```

4. **Callout box**: "Why Tail?" 解释框

### Step 5: 填充 Stage 3 (20 分钟)

1. **绘制 Before 条形图**:
   ```
   Member bar:
     - 长度: 2.5cm (对应 7.8 分数)
     - 颜色: 绿色 (#19A979)
     - 标签: "7.8" (右侧)
   
   Non-member bar:
     - 长度: 1.3cm (对应 4.2)
     - 颜色: 红色 (#C0392B)
     - 标签: "4.2" (右侧)
   
   Gap 箭头:
     - 灰色虚线, 双向
     - 标签: "Large (spurious)"
   ```

2. **中间步骤**:
   ```
   Length matching:
     - 小图标: [M1↔NM1] [M2↔NM2]
     - 灰色框 + 双向箭头
   
   Calibration 公式:
     - 背景: 浅灰色框
     - 公式: Residual = Score - f(length, density)
   ```

3. **绘制 After 条形图**:
   ```
   Member bar: 1.5cm (4.5), 绿色
   Non-member bar: 1.2cm (3.8), 红色
   Gap 箭头: 实线, "Smaller (true)"
   ```

4. **混淆警告**:
   - ⚠ 图标 (黄色) 在 Before 旁
   - 标签: "Confounded"

### Step 6: 填充 Stage 4 (15 分钟)

1. **绘制特征输入框** (9 个):
   ```
   位置: 左侧垂直排列
   尺寸: 1.2cm × 0.4cm
   
   特征列表:
     1. TIS_top64   (蓝色框, 加粗)
     2. TIS_top32   (蓝色框)
     3. TIS_top128  (蓝色框)
     4. Win_p95_64  (紫色框)
     5. Win_p95_32  (紫色框)
     6. Fwd_NLL_64  (灰色框)
     7. Rev_NLL_64  (灰色框)
     8. ... (省略框, 虚线)
     9. (Total 9)
   ```

2. **绘制融合器**:
   ```
   形状: 圆形节点 (直径 1cm)
   颜色: 深蓝色填充
   标签: "LogReg" (白色文字)
   位置: 右侧居中
   ```

3. **连接箭头**:
   - 从每个特征框到融合器节点
   - 细灰色箭头, 0.5pt

4. **输出公式框**:
   ```
   位置: 融合器下方
   背景: 浅蓝色 (#D6EAF8)
   公式: P(member) = σ(w·x + b)
   ```

5. **交叉验证标注**:
   - 底部小图标: F1, F2, F3, F4, F5
   - 标签: "5-Fold CV (Composer-Stratified)"

### Step 7: 填充 Output (5 分钟)

1. **分数显示**:
   ```
   数值: "0.87"
   字体: 粗体, 18pt
   颜色: 绿色 (#19A979)
   ```

2. **判决图标**:
   ```
   ✓ Member (绿色勾, 24pt)
   位置: 分数下方
   ```

3. **阈值标注**:
   ```
   标签: "@1%FPR"
   字体: 小字, 7pt
   虚线: 指向决策边界
   ```

### Step 8: 连接箭头 (10 分钟)

1. **主流程箭头**:
   ```
   Input → Stage 1: 
     - 标签: "Raw Tokens"
   
   Stage 1 → Stage 2:
     - 标签: "Structural Tokens (~150)"
   
   Stage 2 → Stage 3:
     - 标签: "Top-k NLL (k=64)"
   
   Stage 3 → Stage 4:
     - 标签: "Debiased Scores"
   
   Stage 4 → Output:
     - 标签: "P(member)"
   ```

2. **箭头样式统一**:
   - 宽度: 2pt
   - 颜色: 深灰色 (#2C3E50)
   - 箭头头: 填充三角形

### Step 9: 添加图例与标注 (5 分钟)

1. **图例**:
   ```
   位置: 底部居中
   背景: 浅灰色框
   内容: (见上文图例设计)
   ```

2. **Caption**:
   ```
   位置: 图下方
   内容: "Figure 1: TS-RaMIA pipeline. Structural masking 
          isolates lattice tokens; tail-of-top-k captures 
          sparse memorization; meta-fusion combines debiased cues."
   字体: 9pt, 斜体
   ```

### Step 10: 最终调整 (10 分钟)

1. **对齐检查**:
   - 所有 Stage 顶部对齐
   - 所有箭头水平居中
   - 所有文字左对齐或居中

2. **配色检查**:
   - 用色盲模拟器检查
   - 转为灰度查看对比度

3. **可读性检查**:
   - 缩小到 50% 查看
   - 确保最小字号 ≥ 6pt

4. **导出**:
   - 格式: PDF (矢量)
   - 分辨率: 300 DPI (如果有栅格元素)
   - 文件名: `figure1_tsramia_pipeline.pdf`

---

## 📄 TikZ LaTeX 完整代码模板

```latex
\documentclass[tikz,border=10pt]{standalone}
\usepackage{tikz}
\usetikzlibrary{shapes,arrows,positioning,calc,fit,backgrounds}
\usepackage{amsmath}
\usepackage{amssymb}

% 定义颜色
\definecolor{primaryblue}{RGB}{46,80,144}
\definecolor{accentorange}{RGB}{232,116,59}
\definecolor{successgreen}{RGB}{25,169,121}
\definecolor{secondarypurple}{RGB}{139,90,158}
\definecolor{negred}{RGB}{192,57,43}
\definecolor{textdark}{RGB}{44,62,80}
\definecolor{bglight}{RGB}{236,240,241}

% 定义样式
\tikzstyle{stagebox} = [
  rectangle, 
  draw=textdark, 
  thick,
  fill=bglight,
  minimum width=3.5cm,
  minimum height=7.5cm,
  align=center
]

\tikzstyle{stagehead} = [
  rectangle,
  fill=primaryblue,
  text=white,
  font=\bfseries,
  minimum width=3.5cm,
  minimum height=0.8cm
]

\tikzstyle{iobox} = [
  rectangle,
  draw=textdark,
  thick,
  minimum width=2cm,
  minimum height=2cm,
  align=center
]

\tikzstyle{arrow} = [
  thick,
  ->,
  >=stealth,
  draw=textdark
]

\tikzstyle{structtoken} = [
  rectangle,
  draw=accentorange,
  thick,
  fill=white,
  minimum width=0.4cm,
  minimum height=0.4cm
]

\begin{document}
\begin{tikzpicture}[node distance=0.3cm]

% ========== Input ==========
\node[iobox] (input) {
  \textbf{MIDI Sequence} \\[0.2cm]
  {\large \texttt{♪ ♪ ♫ ♩}} \\[0.1cm]
  {\footnotesize $T=1024$}
};

% ========== Stage 1: Structural Masking ==========
\node[stagebox, right=of input] (stage1) {};
\node[stagehead, anchor=north] at (stage1.north) {Stage 1: Structural Masking};

% Stage 1 内容 (在此添加 tokens, mask, filtered output)
% ...

% ========== Stage 2: Tail-of-Loss ==========
\node[stagebox, right=of stage1] (stage2) {};
\node[stagehead, anchor=north] at (stage2.north) {Stage 2: Tail-of-Loss};

% Stage 2 内容 (柱状图, Top-k 标注, 公式)
% ...

% ========== Stage 3: Debiasing ==========
\node[stagebox, right=of stage2] (stage3) {};
\node[stagehead, anchor=north] at (stage3.north) {Stage 3: Debiasing};

% Stage 3 内容 (Before/After 条形图)
% ...

% ========== Stage 4: Meta-Fusion ==========
\node[stagebox, right=of stage3] (stage4) {};
\node[stagehead, anchor=north] at (stage4.north) {Stage 4: Meta-Fusion};

% Stage 4 内容 (特征框, 融合器, 公式)
% ...

% ========== Output ==========
\node[iobox, right=of stage4] (output) {
  \textbf{Decision} \\[0.3cm]
  {\Large \color{successgreen} \textbf{0.87}} \\[0.1cm]
  {\color{successgreen} \checkmark Member} \\[0.1cm]
  {\footnotesize @1\%FPR}
};

% ========== 连接箭头 ==========
\draw[arrow] (input) -- node[above, font=\small\itshape] {Raw Tokens} (stage1);
\draw[arrow] (stage1) -- node[above, font=\small\itshape] {Struct Tokens} (stage2);
\draw[arrow] (stage2) -- node[above, font=\small\itshape] {Top-k NLL} (stage3);
\draw[arrow] (stage3) -- node[above, font=\small\itshape] {Debiased} (stage4);
\draw[arrow] (stage4) -- node[above, font=\small\itshape] {$P(\text{member})$} (output);

% ========== 图例 ==========
\node[draw=textdark, thick, fill=white, anchor=south, font=\footnotesize] 
  at ($(stage2.south)!0.5!(stage3.south) + (0,-0.5)$) {
  \textbf{Legend:} 
  \textcolor{successgreen}{■} Member \quad
  \textcolor{negred}{■} Non-member \quad
  \textcolor{accentorange}{■} Structural
};

\end{tikzpicture}
\end{document}
```

**注意**: 这是框架代码，需要填充每个 Stage 的具体内容（tokens, 图表, 公式等）。

---

## 🎨 draw.io / Figma 绘图提示

如果使用 draw.io 或 Figma:

### draw.io 步骤

1. **导入模板**: 使用 "Flow Chart" 模板
2. **设置画布**: 18cm × 9cm (File → Page Setup)
3. **使用组件**:
   - Rectangle (Ctrl+M) 绘制 Stage
   - Arrow (Ctrl+E) 连接
   - Text (Ctrl+T) 添加标签
4. **配色**: 在右侧 Style 面板设置 RGB 值
5. **对齐**: 使用 Arrange → Align 工具
6. **导出**: File → Export as → PDF (选择 "Selection Only")

### Figma 步骤

1. **创建 Frame**: 18cm × 9cm
2. **使用插件**:
   - "Charts" 插件绘制柱状图
   - "Iconify" 插件添加图标
3. **组件库**: 创建 Stage 组件模板
4. **自动布局**: 使用 Auto Layout 对齐
5. **导出**: Export → PDF (2x resolution)

---

## ✅ 最终检查清单

绘制完成后，逐项检查:

- [ ] **尺寸**: 18cm × 9cm (宽×高)
- [ ] **分辨率**: 矢量图 或 300 DPI
- [ ] **格式**: PDF (首选) 或 PNG
- [ ] **配色**: 所有颜色符合配色方案
- [ ] **文字**: 最小字号 ≥ 6pt
- [ ] **对齐**: 所有元素水平/垂直对齐
- [ ] **间距**: Stage 间距 0.3cm
- [ ] **箭头**: 所有箭头有标签
- [ ] **图例**: 包含所有使用的符号
- [ ] **Caption**: 与论文 Introduction 一致
- [ ] **灰度**: 灰度模式下可区分
- [ ] **色盲**: 色盲模拟器检查通过
- [ ] **可读性**: 50% 缩放仍可读

---

## 📚 参考资源

### 顶会 Pipeline 图范例

1. **BERT 论文** (Figure 1): 横向 pipeline, 清晰标注
2. **ResNet 论文** (Figure 2): 模块化设计, 统一色彩
3. **GPT-3 论文** (Figure 1): 简洁流程, 关键数字突出

### 工具链接

- **TikZ Gallery**: https://texample.net/tikz/examples/
- **draw.io**: https://app.diagrams.net/
- **Figma**: https://www.figma.com/
- **Color Blind Simulator**: https://www.color-blindness.com/coblis-color-blindness-simulator/

### LaTeX 包

```latex
\usepackage{tikz}
\usetikzlibrary{shapes,arrows,positioning,calc,fit,backgrounds}
```

---

## 🎯 总结

这张 Figure 1 设计遵循了顶会论文的最佳实践:

1. ✅ **清晰的信息层次**: Pipeline 主流程 → 核心概念 → 技术细节
2. ✅ **一致的视觉语言**: 统一配色, 统一符号
3. ✅ **简洁而完整**: 不遗漏关键步骤, 不添加冗余
4. ✅ **专业的排版**: 对齐, 间距, 字体规范
5. ✅ **可访问性**: 色盲友好, 灰度可读

**预期效果**: 审稿人看到这张图后, 能在 30 秒内理解 TS-RaMIA 的核心思想, 并对论文产生好印象。

**绘制时间估算**:
- TikZ (LaTeX): 2-3 小时 (首次), 1 小时 (熟练后)
- draw.io: 1-1.5 小时
- Figma/Illustrator: 1.5-2 小时

祝绘图顺利！🎨


