# Operator Splitting Value Iteration
This is the code for experiments in the paper "Operator Splitting Value Iteration" at NeurIPS2022. 

## To reproduce all the plots
Simply run the runner.sh script in bash:

```
sh ./runner.sh
```

## To run an OSVI experiment

You can use exp_pe_vector.py or exp_control_vector.py for the PE and control problems along a config file. For example:

```
python ./exp_pe_vector.py <configfilename.yaml> ALL
python ./exp_control_vector.py <configfilename.yaml> ALL
```

## To run an OSDyna experiment

You can use exp_pe_sample.py or exp_control_sample.py for the PE and control problems along a config file. For example:
```
python ./exp_pe_sample.py <configfilename.yaml> ALL --num_trials 20 --plot_every 1
python ./exp_control_sample.py <configfilename.yaml> ALL --num_trials 20 --plot_every 1
```

