#!/bin/bash

# Parameter search space
TEMPERATURES=(0.6 0.8 1.0 1.2)
MINI_BATCH_SIZES=(1 16 128)
USE_KL_OPTIONS=(False True)
LEARNING_RATES=("1e-6" "5e-6")
LR_SCHEDULERS=("constant" "cosine")

# Path to the sbatch script
SBATCH_SCRIPT="URLVR/examples/unsupervised_rlvr/ensemble-based.sh"

# Loop over all parameter combinations

# for use_kl in "${USE_KL_OPTIONS[@]}"; do

#     temp=1.0
#     mbs=16
#     lr="1e-6"
#     lr_scheduler="constant"
            
#     echo "Submitting job with:"
#     echo "  TEMPERATURE     = $temp"
#     echo "  MINI_BATCH_SIZE = $mbs"
#     echo "  USE_KL          = $use_kl"
#     echo "  LR              = $lr"
#     echo "  LR_SCHEDULER    = $lr_scheduler"
#     echo "----------------------------------"

#     export TEMPERATURE=$temp
#     export MINI_BATCH_SIZE=$mbs
#     export USE_KL=$use_kl
#     export LR=$lr
#     export LR_SCHEDULER=$lr_scheduler
    
#     sbatch "$SBATCH_SCRIPT"

# done

# for temp in "${TEMPERATURES[@]}"; do

#     use_kl=False
#     mbs=16
#     lr="1e-6"
#     lr_scheduler="constant"
                    
#     echo "Submitting job with:"
#     echo "  TEMPERATURE     = $temp"
#     echo "  MINI_BATCH_SIZE = $mbs"
#     echo "  USE_KL          = $use_kl"
#     echo "  LR              = $lr"
#     echo "  LR_SCHEDULER    = $lr_scheduler"
#     echo "----------------------------------"

#     export TEMPERATURE=$temp
#     export MINI_BATCH_SIZE=$mbs
#     export USE_KL=$use_kl
#     export LR=$lr
#     export LR_SCHEDULER=$lr_scheduler
    
#     sbatch "$SBATCH_SCRIPT"

# done

for mbs in "${MINI_BATCH_SIZES[@]}"; do

    temp=1.0
    use_kl=False
    lr="1e-6"
    lr_scheduler="constant"
                    
    echo "Submitting job with:"
    echo "  TEMPERATURE     = $temp"
    echo "  MINI_BATCH_SIZE = $mbs"
    echo "  USE_KL          = $use_kl"
    echo "  LR              = $lr"
    echo "  LR_SCHEDULER    = $lr_scheduler"
    echo "----------------------------------"

    export TEMPERATURE=$temp
    export MINI_BATCH_SIZE=$mbs
    export USE_KL=$use_kl
    export LR=$lr
    export LR_SCHEDULER=$lr_scheduler
    
    sbatch "$SBATCH_SCRIPT"

done

# Loop over all parameter combinations
# for temp in "${TEMPERATURES[@]}"; do
#     for mbs in "${MINI_BATCH_SIZES[@]}"; do
#         for use_kl in "${USE_KL_OPTIONS[@]}"; do
#             for lr in "${LEARNING_RATES[@]}"; do
#                 for lr_scheduler in "${LR_SCHEDULERS[@]}"; do
#                     # Skip cosine scheduler for 1e-6 to reduce redundant runs if not desired
#                     if [ "$lr" = "1e-6" ] && [ "$lr_scheduler" = "cosine" ]; then
#                         continue
#                     fi
                    
#                     echo "Submitting job with:"
#                     echo "  TEMPERATURE     = $temp"
#                     echo "  MINI_BATCH_SIZE = $mbs"
#                     echo "  USE_KL          = $use_kl"
#                     echo "  LR              = $lr"
#                     echo "  LR_SCHEDULER    = $lr_scheduler"
#                     echo "----------------------------------"

#                     export TEMPERATURE=$temp
#                     export MINI_BATCH_SIZE=$mbs
#                     export USE_KL=$use_kl
#                     export LR=$lr
#                     export LR_SCHEDULER=$lr_scheduler
                    
#                     sbatch "$SBATCH_SCRIPT"
#                 done
#             done
#         done
#     done
# done

echo "All parameter search jobs submitted."
