# CTQWformer (ICLR 2026 Submission)

This repository provides the implementation of **CTQWformer**, a novel graph classification framework that integrates **Continuous-Time Quantum Walk (CTQW)** with graph Transformer and recurrent neural network. The model leverages graph neural networks to capture the dynamical evolution of quantum walks, jointly exploiting their structural biases and temporal information for graph learning.

---

## 🧠 Model Overview

CTQWformer consists of two synergistic modules:

- **QWGT module**: Applies Transformer attention with CTQW-based structural bias.
- **QWGR module**: Extracts dynamic embeddings from temporal quantum walk sequences via a BiGRU.

These modules are fused and stacked to produce graph-level representations for classification.


### ⚙️ Environment (Recommended)

All experiments are conducted on a cloud server with the following configuration:

- **OS**: Ubuntu 22.04 (x86_64)
- **Python**: 3.12
- **PyTorch**: 2.5.1
- **CUDA**: 12.4
- **GPU**: NVIDIA RTX 4090 (24GB) × 1
- **CPU**: 20 vCPUs (Intel(R) Xeon(R) Platinum 8470Q)
- **RAM**: 90 GB
- **Disk**: 30 GB (system disk)

### 🔧 Install dependencies
```bash
pip install -r requirements.txt
```
### 🚀 Run Demo
You can run a single experiment or perform a full grid search over hyperparameters.

🔹 Option 1: Run the default demo on MUTAG
```bash
python main.py
```

This will run a 10-fold cross-validation using predefined settings such as:

- dataset = MUTAG

- hidden_dim = 64

- num_layers = 2

- time_steps = [1.0, 2.0, 3.0, 4.0]

- fusion = 'cat'

- heads = 4

- dropout = 0.3

- use_attention_bias = True

- use_sequence_model = True
The result (accuracy and std) will be logged to:
```bash
results/grid_search_results.csv
```
🔹 Option 2: Run full grid search
```bash
python grid_search.py
```
This script will exhaustively search across combinations of model depth, learning rate, dropout, attention heads, etc., and log all performance results in the same .csv file.

Modify the parameter space in grid_search.py as needed:
```python
hidden_dims = [64]
lrs = [1e-3]
layers = [2, 4]
time_steps_list = [torch.tensor([1.0, 2.0, 3.0, 4.0]), torch.tensor([1.0, 2.0, 3.0, 4.0, 5.0, 6.0])]
...

```
All configurations are reproducible with a fixed seed (seed=42).





