import torch
import numpy as np

num_players = 40
num_arms = 5

arms_ranking = [ [] for j in range(num_arms)]
for j in range(num_arms):
    for i in range(num_players):
        arms_ranking[j].append(i)

players_ranking = [[] for i in range(num_players)]

for i in range(num_players):
    for j in range(num_arms):
        players_ranking[i].append(j)

players_mean = [np.zeros([num_arms]) for j in range(num_players)]
for i in range(num_players):
    for j in range(num_arms):
        rank = players_ranking[i].index(j)
        players_mean[i][j] = (num_arms-rank) / num_arms
players_mean = np.array(players_mean)
players_mean = torch.from_numpy(players_mean)

np.savez('./Markets/global_N_'+str(num_players)+'K_'+str(num_arms)+'.npz', player_rank = players_ranking, arm_rank=arms_ranking ,player_mean = players_mean)

market = np.load('./Markets/global_N_'+str(num_players)+'K_'+str(num_arms)+'.npz')
# print("Size", len(market['player_rank']))
print("Player_rank", market['player_rank'])
print("Arm_rank", market['arm_rank'])
print("Player_mean", market['player_mean'])