import json
from functools import partial
from torch import optim as optim
from .utils import build_finetune_optimizer, build_pretrain_optimizer


def build_optimizer(config, model, logger, is_pretrain):
    if is_pretrain:
        return build_pretrain_optimizer(config, model, logger)
    else:
        return build_finetune_optimizer(config, model, logger)


