

```markdown
# ICLR GRE Code

This repository contains the code for the ICLR GRE project, which includes prompt generation, response generation, attack implementation, and score evaluation.

## 1. Prompt Generation

We use DiffuseQ text paraphraser to randomly generate prompts.

### Usage
[Provide instructions on how to use DiffuseQ for prompt generation]

## 2. Generation

This section involves generating responses for both pure prompts and attacked prompts using TrustLLM.

### Usage
To generate responses:

1. Prepare your input JSONL file for the specified task.
2. Use the `test_2` or `test_attack` function in TrustLLM:

```python
python TrustLLM-main/test_2.py --input_file path/to/your/input.jsonl --output_file path/to/output.jsonl
```

or

```python
python TrustLLM-main/test_attack.py --input_file path/to/your/input.jsonl --output_file path/to/output.jsonl
```

## 3. Attack

We use the TextAttack Package (TAP) to perform attacks on the given dataset and target model.

### Usage
To run the attack:

```python
python TAP-main/main_tap.py --dataset your_dataset --target_model your_target_model
```

[Add any additional parameters or options for the attack script]

## 4. Score Evaluation

We use `cal_trustllm_score_total.py` to calculate GRE Scores and correlations for the generated responses.

### Usage
To evaluate the scores:

```python
python cal_trustllm_score_total.py --input_file path/to/generated_responses.jsonl --output_file path/to/evaluation_results.json
```




