#!/bin/sh

model=$1
peft=$2
lr=$3

test_batch=32

if [ "$peft" = "base" ]; then
    init_weights="none"

elif [ "$peft" = "lora" ]; then
    init_weights="pissa"


elif [ "$peft" = "dora" ]; then
    init_weights="pissa"


elif [ "$peft" = "hoft" ]; then
    init_weights="normal"
    

elif [ "$peft" = "shoft" ]; then
    init_weights="normal"
 
else
    init_weights="none"

fi

python commonsense_reasoning.py \
    -dataset 'all' \
    -model $model \
    -lr $lr \
    -r 16 \
    -peft_type $peft \
    -epochs 2 \
    -batch_size 4 \
    -test_batch_size $test_batch \
    -acc_steps 4 \
    -dropout 0.05 \
    -init_weights $init_weights \
    --use_wandb
