#!/bin/sh

dataset_name=$1
peft=$2
lr=$3

if [ "$dataset_name" = "openai/gsm8k" ]; then
    epochs=3


elif [ "$dataset_name" = "microsoft/orca-math-word-problems-200k" ]; then
    epochs=2

else
    epochs=1

fi

python llama.py \
    -dataset_name $dataset_name \
    -model 2 \
    -lr $lr \
    -r 16 \
    -peft_type $peft \
    -epochs $epochs \
    -batch_size 4 \
    -test_batch_size 16 \
    -acc_steps 1 \
    -dropout 0.05 \
    --use_wandb

