#!/usr/bin/env bash
DATALIST=(iNaturalist18)
BATCHSIZE=(512)
EPOCH=30
MODEL=resnet50
CHECKPOINTS=ckps
R=.pth.tar
DR=10
GPUS=(1)
ALGNAME=(PDSGD)
LAMDA0=(50)
WLR=(0.1)
PLR=(1e-5 0.05 0.0005)
IMRATIO=(0.02 0.2)
RHO=(0.5)
BETA=(0.2 0.6 0.8)
CLASSTAU=(0.05 0.1 0.15)
ISTLB=True

for((da=0; da<1; da++)); do
{
for((wlr=0; wlr<1; wlr++)); do
{
for((agm=0; agm<1; agm++)); do
{
for((r=0; r<1; r++)); do
{
for((plr=0; plr<1; plr++)); do
{
for((rpt=0; rpt<1; rpt++)); do
{
for((lbd=0; lbd<1; lbd++)); do
{
for((b=0; b<1; b++)); do
{
for((ctu=0; ctu<1; ctu++)); do
{
         python3 -W ignore main.py \
            --dataset ${DATALIST[$da]} \
            --model $MODEL \
            --saveFolder ${DATALIST[$da]}/Decay_lr_${ALGNAME[$agm]}/no_scale_${ALGNAME[$agm]}_wlr_${WLR[$wlr]}_rho_${RHO[$r]}_beta_${BETA[$b]}_plr_${PLR[$plr]}_lambda0_${LAMDA0[$lbd]}_batch_${BATCHSIZE}_epochs_${EPOCH}_model_${MODEL}_DR_${DR}_Repeats_${rpt}_LB_${ISTLB} \
            --res_filename ${DATALIST[$da]}_${ALGNAME[$agm]}_wlr_${WLR[$wlr]}_rho_${RHO[$r]}_beta_${BETA[$b]}_plr_${PLR[$plr]}_lambda0_${LAMDA0[$lbd]}_batch_${BATCHSIZE}_epochs_${EPOCH}_model_${MODEL}_DR_${DR}_Repeats_${rpt}_LB_${ISTLB}  \
            --epochs ${EPOCH} \
            --batch-size ${BATCHSIZE} \
            --gpus ${GPUS[$agm]} \
            --lr ${WLR[$wlr]} \
            --restart_init_loop 1 \
            --lamda1 ${LAMDA0[$lbd]} \
            --epochs ${EPOCH} \
            --alg ${ALGNAME[$agm]} \
            --print_freq 50 \
            --momentum 0.9 \
            --im_ratio ${IMRATIO[$da]} \
            --DR ${DR} \
            --sampleType P \
            --plr ${PLR[$plr]} \
            --rho ${RHO[$r]} \
            --beta ${BETA[$b]}\
            --class_tau ${CLASSTAU[$ctu]} \
            --frozen_aside_fc True \
            --not_frozen_last_block ${ISTLB} \
            --pretrained True \
            --lrlambda 0.00001 \
            --a_t 0.8

}
done
}
done
}
done
}
done
}
done
}
done
}
done
}
done
}
done


# iNaturalist18
# rho = 0.1

# python3 fastdromain.py --algorithm batch --dataset imagenet --data_dir /home/qiuzh/imagenet --epochs 30 --momentum 0.9 --lr_schedule constant --averaging constant_3.0 --wd 1e-3 --geometry chi-square --size 1.0 --batch_size 500 --lr 1e-2 --output_dir ../output-dir
# datasets:  imagenet-LT, iNaturalist18
#