# Instructions for running Maze-D and Maze-MR experiments 

## Download datasets

Datasets used for Maze-D and Maze-MR experiments are available [here](https://drive.google.com/file/d/1WjdIJV3b6MKvppnGHGbwU8IND-t8UNOE/view?usp=sharing). Please place `datasets/` in `custom_locomotion/`.

## Run experiments

You can run experiments for Maze-D and Maze-MR by following commands.

### Ours

#### Maze-D

```bash
python ours/multi_seed.py n=1 exp_type=p2m maze_type=medium 
```

#### Maze-MR

```bash
python ours/multi_seed.py n=1 exp_type=p2a maze_type=medium 
```

### GAMA

```bash
python dail/multi_seed.py n=1 exp_type=p2m maze_type=medium 
```

### CCA

```bash
python cca/multi_seed.py n=1 exp_type=p2m maze_type=medium 
```

### Options

You can specify the following options for `multi_seed.py`.

- `n` is the number to repeat the experiment.
- `exp_type` specifies the type of the experiment.
  - `p2m` for Maze-D and `p2a` for Maze-MR.
- `maze_type` specifies the shape of the maze.
  - `umaze` or `medium`.
- `num_epoch` specifies the number of epochs to train alignment for Ours and GAMA.
- `max_steps` specifies the number of environmental steps for CCA.
- `goal` specifies goal id.
  - we used `2,5,6` for umaze, and `4,14,25` for medium.
  - These IDs correspond to those in Maze2D.
- `device_` specifies which GPU to run experiments.

#### Example

```bash
python ours/multi_seed.py n=3 exp_type=p2a maze_type=medium num_epoch=50 goal=14 device_=0
```
