# AInstein: CAN AI REDISCOVER SCIENTIFIC CONCEPTS FROM FIRST PRINCIPLES

Configure the Application

Create a `.env` file in the root of the project:

```env
# .env file
VLLM_BASE_URL="http://localhost:8000/v1"
```

---

## Directory Structure

```
/
├── main.py
└── prompts/
└── agents/
└── services/
└── configs/
    ├── generalizer.yml
    └── solver.yml
└── scripts/
    ├── __init__.py
    ├── generalizer_composite.py
    ├── generalizer_monolithic.py
    ├── solver_composite.py
    └── solver_monolithic.py
```


## Usage
You can run tasks using the main.py script and specifying the task and reviewer types with command-line flags.

### Arguments
- `--task-type`, `-t`
    - Description: The name of the primary task to execute.
    - Choices: generalize, solve
- `--reviewer-type`, `-e`
    - Description: The type of reviewer module to use for the task.
    - Choices: composite, monolithic


## Examples
Here are some examples of how to run the workflow.

### Run the 'generalize' task with the 'composite' reviewer:


```bash
python main.py --task-type generalize --reviewer-type composite
```

### Run the 'solve' task with the 'monolithic' reviewer using short flags:

```bash
python main.py -t solve -e monolithic
```

### Run the 'generalize' task with the 'monolithic' reviewer:

```bash
python main.py -t generalize -e monolithic
```