# This file was scaffolded by `agenkit`.
# The `agenkit build` command will generate the code for this agent.

import typer
from agenkit.agents import BaseAgent, BaseComponent
from datetime import datetime
from prompts import GeneralizerPrompts  # This will be uncommented by the build command


class GeneralizerAgent(BaseAgent):
    # AGENKIT-GENERATED:START:__init__

    def __init__(self, prompts: GeneralizerPrompts, agent_name: str, **kwargs):
        super().__init__(**kwargs)
        self.prompts = prompts
        self.agent_name = agent_name

    # AGENKIT-GENERATED:END:__init__

    # AGENKIT-GENERATED:START:run

    async def run(self, workflow_log: dict, **kwargs):
        """
        AUTO-GENERATED by `agenkit build` from plan.yml.
        This method orchestrates the agent's steps.
        """
        context = kwargs.copy()
        typer.echo("Executing step: generalize...")

        # Start of Step Implementations

        # Step: generalize
        step_key = f"{self.agent_name}.generalize"
        # Add a unique suffix for logs in a loop
        log_key = step_key
        i = 1
        while log_key in workflow_log:
            log_key = f"{step_key}_{i}"
            i += 1

        workflow_log[log_key] = {
            "status": "RUNNING",
            "start_time": datetime.now().isoformat(),
            "output": None,
            "error": None,
        }
        try:
            step_1_comp = BaseComponent(
                model_name=self.model_name,
                model_provider=self.model_provider,
                system_prompt=self.prompts.generalize.system,
                user_prompt_template=self.prompts.generalize.user,
            )
            step_1_result = await step_1_comp.execute(
                self.llm_router,
                prompt_format_kwargs={"abstract": context["initial_input"]},
            )
            output = step_1_result["response"]
            context[f"{self.agent_name}.generalize.output"] = output
            workflow_log[log_key].update({"status": "COMPLETED", "output": output})
        except Exception as e:
            error_message = f"{e.__class__.__name__}: {e}"
            typer.secho(
                f"    ❌ Error during step 'generalize': {error_message}",
                fg=typer.colors.RED,
            )
            workflow_log[log_key].update({"status": "FAILED", "error": error_message})
            raise  # Re-raise the exception to halt the workflow
        finally:
            workflow_log[log_key]["end_time"] = datetime.now().isoformat()

        # End of Step Implementations

        context[f"{self.agent_name}.final.output"] = context.get(
            f"{self.agent_name}.generalize.output"
        )
        return context

    # AGENKIT-GENERATED:END:run
