# This file was scaffolded by `agenkit`.
# The `agenkit build` command will generate the code for this agent.

import typer
from agenkit.agents import BaseAgent, BaseComponent
from datetime import datetime
import sys
from pathlib import Path

sys.path.insert(0, str(Path(__file__).parent.parent))
from prompts import (
    SrSolverPrompts,
)  # This will be uncommented by the build command


class SrSolverAgent(BaseAgent):
    # AGENKIT-GENERATED:START:__init__

    def __init__(self, prompts: SrSolverPrompts, agent_name: str, **kwargs):
        super().__init__(**kwargs)
        self.prompts = prompts
        self.agent_name = agent_name

    # AGENKIT-GENERATED:END:__init__

    # AGENKIT-GENERATED:START:run

    async def run(self, workflow_log: dict, **kwargs):
        """
        AUTO-GENERATED by `agenkit build` from plan.yml.
        This method orchestrates the agent's steps.
        """
        context = kwargs.copy()
        typer.echo("Executing step: measure...")

        # Start of Step Implementations

        # Step: measure
        step_key = f"{self.agent_name}.measure"
        # Add a unique suffix for logs in a loop
        log_key = step_key
        i = 1
        while log_key in workflow_log:
            log_key = f"{step_key}_{i}"
            i += 1

        workflow_log[log_key] = {
            "status": "RUNNING",
            "start_time": datetime.now().isoformat(),
            "output": None,
            "error": None,
        }
        try:
            step_1_comp = BaseComponent(
                model_name=self.model_name,
                model_provider=self.model_provider,
                system_prompt=self.prompts.measure.system,
                user_prompt_template=self.prompts.measure.user,
            )
            step_1_result = await step_1_comp.execute(
                self.llm_router,
                prompt_format_kwargs={
                    "gt": context["generalizer_output"],  # Problem Statement
                    "pred": context["solution"],  # Proposed Solution
                },
            )
            output = step_1_result["response"]
            context[f"{self.agent_name}.measure.output"] = output
            workflow_log[log_key].update({"status": "COMPLETED", "output": output})
        except Exception as e:
            error_message = f"{e.__class__.__name__}: {e}"
            typer.secho(
                f"    ❌ Error during step 'measure': {error_message}",
                fg=typer.colors.RED,
            )
            workflow_log[log_key].update({"status": "FAILED", "error": error_message})
            raise  # Re-raise the exception to halt the workflow
        finally:
            workflow_log[log_key]["end_time"] = datetime.now().isoformat()

        # End of Step Implementations

        context[f"{self.agent_name}.final.output"] = context.get(
            f"{self.agent_name}.measure.output"
        )
        return context

    # AGENKIT-GENERATED:END:run
