# This factory is a placeholder for your compiled agents.
# The `agenkit build` command can populate this for you.
from agenkit.agents import BaseAgent
from agenkit.core.prompting.loader import load_prompts_from_yaml

# AGENKIT-GENERATED:START:factory_logic
from agents.generalizer_agent import GeneralizerAgent
from agents.semantic_fidelity_agent import SemanticFidelityAgent
from agents.jargon_reduction_agent import JargonReductionAgent
from agents.first_principles_agent import FirstPrinciplesAgent
from agents.information_loss_agent import InformationLossAgent
from agents.problem_ambiguity_agent import ProblemAmbiguityAgent
from agents.problem_solution_leakage_agent import ProblemSolutionLeakageAgent
from agents.generalizer_monolithic_reviewer_agent import (
    GeneralizerMonolithicReviewerAgent,
)
from agents.generalizer_final_quality_judgement_agent import (
    GeneralizerFinalQualityJudgementAgent,
)
from agents.generalizer_retry_agent import GeneralizerRetryAgent
from agents.solver_agent import SolverAgent
from agents.solution_creativity_agent import SolutionCreativityAgent
from agents.solution_completeness_agent import SolutionCompletenessAgent
from agents.solution_technical_feasibility_agent import (
    SolutionTechnicalFeasibilityAgent,
)
from agents.solver_monolithic_reviewer_agent import SolverMonolithicReviewerAgent
from agents.solver_final_quality_judgement_agent import SolverFinalQualityJudgementAgent
from agents.solver_retry_agent import SolverRetryAgent
from agents.solution_equivalence_agent import SolutionEquivalenceAgent
from agents.rediscovery_agent import RediscoveryAgent
from agents.sr_solver_agent import SrSolverAgent
from agents.sr_generalizer_agent import SrGeneralizerAgent
from prompts import (
    GeneralizerPrompts,
    SemanticFidelityPrompts,
    JargonReductionPrompts,
    FirstPrinciplesPrompts,
    InformationLossPrompts,
    ProblemAmbiguityPrompts,
    ProblemSolutionLeakagePrompts,
    GeneralizerMonolithicReviewerPrompts,
    GeneralizerFinalQualityJudgementPrompts,
    GeneralizerRetryPrompts,
    SolverPrompts,
    SolutionCreativityPrompts,
    SolutionCompletenessPrompts,
    SolutionTechnicalFeasibilityPrompts,
    SolverMonolithicReviewerPrompts,
    SolverFinalQualityJudgementPrompts,
    SolverRetryPrompts,
    SolutionEquivalencePrompts,
    RediscoveryPrompts,
    SrSolverPrompts,
    SrBaselinePrompts,
    SrGeneralizerPrompts,
)


def create_agent(agent_type: str, **kwargs: any) -> BaseAgent:
    """Factory for creating agents specific to this application."""
    if agent_type == "generalizer":
        prompts = load_prompts_from_yaml(
            "prompts/generalizer_prompts.yml", GeneralizerPrompts
        )
        return GeneralizerAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["semantic_fidelity", "semantic_fidelity_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/semantic_fidelity_prompts.yml", SemanticFidelityPrompts
        )
        return SemanticFidelityAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["jargon_reduction", "jargon_reduction_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/jargon_reduction_prompts.yml", JargonReductionPrompts
        )
        return JargonReductionAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["first_principles", "first_principles_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/first_principles_prompts.yml", FirstPrinciplesPrompts
        )
        return FirstPrinciplesAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["information_loss", "information_loss_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/information_loss_prompts.yml", InformationLossPrompts
        )
        return InformationLossAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["problem_ambiguity", "problem_ambiguity_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/problem_ambiguity_prompts.yml", ProblemAmbiguityPrompts
        )
        return ProblemAmbiguityAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in [
        "problem_solution_leakage",
        "problem_solution_leakage_external",
    ]:
        prompts = load_prompts_from_yaml(
            "prompts/problem_solution_leakage_prompts.yml",
            ProblemSolutionLeakagePrompts,
        )
        return ProblemSolutionLeakageAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type in [
        "generalizer_monolithic_reviewer",
        "generalizer_monolithic_reviewer_external",
    ]:
        prompts = load_prompts_from_yaml(
            "prompts/generalizer_monolithic_reviewer_prompts.yml",
            GeneralizerMonolithicReviewerPrompts,
        )
        return GeneralizerMonolithicReviewerAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type in [
        "generalizer_final_quality_judgement",
        "generalizer_final_quality_judgement_external",
    ]:
        prompts = load_prompts_from_yaml(
            "prompts/generalizer_final_quality_judgement_prompts.yml",
            GeneralizerFinalQualityJudgementPrompts,
        )
        return GeneralizerFinalQualityJudgementAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type == "generalizer_retry":
        prompts = load_prompts_from_yaml(
            "prompts/generalizer_retry_prompts.yml", GeneralizerRetryPrompts
        )
        return GeneralizerRetryAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type == "solver":
        prompts = load_prompts_from_yaml("prompts/solver_prompts.yml", SolverPrompts)
        return SolverAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["solution_creativity", "solution_creativity_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/solution_creativity_prompts.yml", SolutionCreativityPrompts
        )
        return SolutionCreativityAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["solution_completeness", "solution_completeness_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/solution_completeness_prompts.yml", SolutionCompletenessPrompts
        )
        return SolutionCompletenessAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type in [
        "solution_technical_feasibility",
        "solution_technical_feasibility_external",
    ]:
        prompts = load_prompts_from_yaml(
            "prompts/solution_technical_feasibility_prompts.yml",
            SolutionTechnicalFeasibilityPrompts,
        )
        return SolutionTechnicalFeasibilityAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type in [
        "solver_monolithic_reviewer",
        "solver_monolithic_reviewer_external",
    ]:
        prompts = load_prompts_from_yaml(
            "prompts/solver_monolithic_reviewer_prompts.yml",
            SolverMonolithicReviewerPrompts,
        )
        return SolverMonolithicReviewerAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type in [
        "solver_final_quality_judgement",
        "solver_final_quality_judgement_external",
    ]:
        prompts = load_prompts_from_yaml(
            "prompts/solver_final_quality_judgement_prompts.yml",
            SolverFinalQualityJudgementPrompts,
        )
        return SolverFinalQualityJudgementAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type == "solver_retry":
        prompts = load_prompts_from_yaml(
            "prompts/solver_retry_prompts.yml", SolverRetryPrompts
        )
        return SolverRetryAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["solution_equivalence", "solution_equivalence_external"]:
        prompts = load_prompts_from_yaml(
            "prompts/solution_equivalence_prompts.yml", SolutionEquivalencePrompts
        )
        return SolutionEquivalenceAgent(
            prompts=prompts, agent_name=agent_type, **kwargs
        )
    elif agent_type == "rediscovery":
        prompts = load_prompts_from_yaml(
            "prompts/rediscovery_prompts.yml", RediscoveryPrompts
        )
        return RediscoveryAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type == "sr_solver":
        prompts = load_prompts_from_yaml(
            "prompts/sr_solver_prompts.yml", SrSolverPrompts
        )
        return SrSolverAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    elif agent_type in ["sr_generalizer", "sr_baseline"]:
        prompts = load_prompts_from_yaml(
            "prompts/sr_generalizer_prompts.yml", SrGeneralizerPrompts
        )
        return SrGeneralizerAgent(prompts=prompts, agent_name=agent_type, **kwargs)
    else:
        raise ValueError(f"Unknown agent type for this application: '{agent_type}'.")


# AGENKIT-GENERATED:END:factory_logic
