#!/bin/sh

# Arguments
mode=$1
exp_name="30K_helpful_dpo_safety_merge"
output_dir="./output/$exp_name"
config_dir="./config/merge"

model_names=(
    "linear_0.25"
    "linear_0.5"
    "linear_0.75"
    "naive_0.25"
    "naive_0.5"
    "naive_0.75"
)

for model_name in "${model_names[@]}"; do
    output_model_path="$output_dir/$model_name"
    merge_config_path="$config_dir/$model_name.yaml"
    cmd="mergekit-yaml $merge_config_path $output_model_path"
    echo "Command: $cmd"
    eval $cmd
done
