# GCBF

Learning decentralized control barrier functions using graph neural networks.

## Dependencies

To install the requirements:

```bash
conda create -n gcbf python=3.9
conda activate gcbf
pip install -r requirements.txt
```

Then you need to install additional packages for torch_geometric following the [official website](https://pytorch-geometric.readthedocs.io/en/latest/).

## Train

To train the model, use:

```bash
python train.py --env SimpleDrone -n 16 --steps 1000000 --area-size 2
```

One can refer to [`settings.yaml`](settings.yaml) for the training parameters. The training logs will be saved in folder `./logs/<env>/<algo>/seed<seed>_<training-start-time>`

## Test

To test the learned model in the same environment as that in training, use:

```bash
python test.py --path <path-to-log> --epi <number-of-episodes> --area-size <area-size>
```

To test the learned model in an environment with different number of agents, use:

```bash
python test.py --path <path-to-log> --epi <number-of-episodes> --area-size <area-size> -n <number-of-agents>
```

You can add the flag `--no-vodeo` for faster tests without generating videos.