import torch

def list_gpus():
    if not torch.cuda.is_available():
        print("No CUDA devices found.")
        return

    num_devices = torch.cuda.device_count()
    print(f"Found {num_devices} CUDA device(s):\n")

    for idx in range(num_devices):
        props = torch.cuda.get_device_properties(idx)
        total_mem_gb = props.total_memory / (1024**3)
        print(f"Index {idx}:")
        print(f"    Name        : {props.name}")
        print(f"    Total VRAM  : {total_mem_gb:.2f} GB")
        print(f"    Multi-Proc. : {props.multi_processor_count} SMs")
        print()

if __name__ == "__main__":
    list_gpus()

