# Untrained-motion-correction
Motion-compensated compressed sensing MRI with untrained neural networks.

***

### List of contents
* [Setup and installation](#Setup-and-installation) <br>
* [Dataset](#Dataset) <br>
* [Experiments](#Experiments) <br>
* [License](#License)
***

# Setup and installation
On a normal computer, it takes aproximately 10 minutes to install all the required softwares and packages.

### OS requirements
The code has been tested on the following operating system:

	Linux: Ubuntu 16.04.5

### Python dependencies
To reproduce the results by running each of the jupyter notebooks, the following softwares are required. Assuming the experiment is being performed in a docker container or a linux machine, the following libraries and packages need to be installed.

        apt-get update
        apt-get install python3.6     # --> or any other system-specific command for installing python3 on your system.
		pip install jupyter
		pip install numpy
		pip install matplotlib
		pip install sigpy
		pip install h5py
		pip install scikit-image==0.17.2

Please install the followings manually;
* PyTorch from [https://pytorch.org/](https://pytorch.org/) according to your system specifications
* Bart toolbox by following the instructions on [https://mrirecon.github.io/bart/](https://mrirecon.github.io/bart/)
* PyTorch wavelets from [https://pytorch-wavelets.readthedocs.io/en/latest/readme.html#installation](https://pytorch-wavelets.readthedocs.io/en/latest/readme.html#installation).

# Dataset

The [FastMRI](https://fastmri.org/dataset) dataset should be download separately. We have created a subset of it whose filenames are in [dataset](dataset).

# Experiments
As detailed in our paper, we consider three motion pattern setups in our 2D experiments. The following notebooks contain those experiments for our untrained network and for l1-norm minimization:
* 10 motion states with random motion pattern --> [only_trans_small.ipynb](only_trans_small.ipynb)
* 24 motion states with random motion pattern --> [only_trans_more_states.ipynb](only_trans_more_states.ipynb)
* 10 motion states with realistic motion pattern --> [only_trans_small_realistic_pattern.ipynb](only_trans_small_realistic_pattern.ipynb)

For the score-based model, we used [the code](https://github.com/utcsilab/motion_score_mri/tree/master) provided by the authors of [accelerated motion correction with score-based generative models](https://arxiv.org/abs/2211.00199).
The example we created based on their code is available under [score_based_example](score_based_example).
To run our example, please send a request to the authors of that work for their model checkpoint `checkpoint_100000.pth`.

# License
This project is covered by **Apache 2.0 License**.