import numpy as np
import pandas as pd
import torch
import preprocess
import pickle
import os

def load_data(name, missing_rate, initial_filling, seed):
    dir_path = f'./data/{name}/processed/missing_rate/{missing_rate}'
    os.makedirs(dir_path, exist_ok=True)
    
    try:
        # load processed dataset if exists    
        with open(dir_path + f'/initial_filling_{initial_filling}_seed_{seed}.pkl', 'rb') as f:
            data, missing_feature_mask = pickle.load(f)
        
        print('Sucessfully loaded processed dataset!')
    
    except:
        # process dataset
        print('Dataset does not exist! Processing...')
        
        if name == 'adult':
            data, missing_feature_mask = preprocess.preprocess_adult(missing_rate, initial_filling)
        elif name == 'adni':
            data, missing_feature_mask = preprocess.preprocess_adni(missing_rate, initial_filling)
        elif name == 'abide':
            data, missing_feature_mask = preprocess.preprocess_abide(missing_rate, initial_filling)
        
        # save processed dataset
        with open(dir_path + f'/initial_filling_{initial_filling}_seed_{seed}.pkl', 'wb') as f:
            pickle.dump([data, missing_feature_mask], f)
                
    return data, missing_feature_mask
