from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from tqdm import trange
from layers import GCN, GAT, SAGE, SGC, MLP
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj, remove_self_loops
from torch_geometric.nn.inits import reset, glorot, zeros
from sklearn.decomposition import PCA
from filling_strategies import filling
import pickle
from tqdm import trange

class GOODIE_2_attn():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)
            
            tmp_edge_index = self.edge_index
            filled_features_fp = filling('fp', tmp_edge_index, self.x, self.missing_feature_mask, self.args.hop, self.args.replace, self.args.num_iterations, self.args.normalize_feature)
            self.x = torch.where(self.missing_feature_mask, self.x, filled_features_fp)

            # Obtain Pseudo Labels
            lp_model = LabelPropagation(num_layers=50, alpha=self.args.lp_alpha)
            # edge_index = remove_self_loops(self.edge_index)[0]
            edge_index = self.edge_index
            lp_output = lp_model(y=self.labels, edge_index=edge_index, mask=self.train_mask)
            self.pseudo_labels = lp_output.argmax(1)
            
            if self.args.lamb != 0.0:
                lp_prediction = torch.softmax(lp_output / 1, 1).max(1)[0]
                lp_prediction[self.train_mask] = 1.0
                lp_pred_mat = lp_prediction
            else:
                lp_pred_mat = None

            # Leveraging partial labels
            self.edge_weight=None
            self.x = torch.nan_to_num(self.x, 0)

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)

            acc_vals = []
            test_results = []
            best_metric = 0

            for epoch in range(0, self.args.epochs):
                model.train()
                optimizer.zero_grad()

                loss_ce, loss_con = model(self.x, lp_output, self.edge_index, self.edge_weight, self.labels, self.pseudo_labels, self.train_mask, weight_mask=lp_pred_mat)
                loss = loss_ce + self.args.lamb * loss_con

                loss.backward()
                optimizer.step()

                # Valid
                model.eval()

                fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)

                if self.args.attn_type == 'og':
                    fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                    lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                    values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
                    output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64
                elif self.args.attn_type == 'random':
                    idx = torch.randperm(self.x.shape[0])[:int(self.x.shape[0]/2)]
                    fp_embed[idx] = lp_embed[idx]
                    output_ = fp_embed
                elif self.args.attn_type == 'sum':
                    output_ = fp_embed + lp_embed
                elif self.args.attn_type == 'mean':
                    output_ = (fp_embed + lp_embed) / 2
                elif self.args.attn_type == 'concat':
                    output_ = torch.cat([fp_embed, lp_embed], 1)

                output = model.classifier3(output_, self.edge_index, self.edge_weight)

                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid', evaluator=self.evaluator)

                acc_vals.append(acc_val)

                if best_metric < acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    st = "[seed {}][{}-{}][{}_{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, self.args.attn_type, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
  
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break

            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info(f'----------- missing rate: {self.args.missing_rate} -----------')
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(f1), np.std(f1)))
        logger.info(self.args)
        logger.info(f'=================================')

        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            classifier1 = GCN(1, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
            classifier2 = GCN(1, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
            if self.args.attn_type == 'concat':
                classifier3 = GCN(1, args.n_hid, 2 * args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
            else:
                classifier3 = GCN(1, args.n_hid, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False)
        elif args.gnn == "SAGE":
            classifier = SAGE(args.n_layer, args.n_feat, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        self.classifier1 = classifier1
        self.classifier2 = classifier2
        self.classifier3 = classifier3
        self.triplet_loss = torch.nn.TripletMarginLoss(margin=1.0, p=2)
        self.leakyrelu = nn.LeakyReLU(args.leaky_alpha)
        self.attention = nn.Parameter(torch.empty(size=(args.n_hid, 1)))
        glorot(self.attention)

    def forward(self, x, lp_embed, edge_index, edge_weight, labels, pseudo_labels, idx_train, weight_mask=None, batch=False):
        _fp_embed = self.classifier1(x, edge_index, edge_weight, embed=True)
        _lp_embed = self.classifier2(lp_embed, edge_index, edge_weight, embed=True)

        if self.args.attn_type == 'og':
            fp_ = self.leakyrelu(torch.mm(_fp_embed, self.attention))
            lp_ = self.leakyrelu(torch.mm(_lp_embed, self.attention))
            values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
            output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64
        elif self.args.attn_type == 'random':
            idx = torch.randperm(x.shape[0])[:int(x.shape[0]/2)]
            _fp_embed[idx] = _lp_embed[idx]
            output_ = _fp_embed
        elif self.args.attn_type == 'sum':
            output_ = _fp_embed + _lp_embed
        elif self.args.attn_type == 'mean':
            output_ = (_fp_embed + _lp_embed) / 2
        elif self.args.attn_type == 'concat':
            output_ = torch.cat([_fp_embed, _lp_embed], 1)

        sup_con_loss = 0

        if self.args.lamb != 0.0:
            centroids = torch.empty((self.args.n_class, output_.shape[1])).to(output_.device)
            for i in range(self.args.n_class):
                idx = pseudo_labels == i
                centroids[i, :] = (output_[idx] * weight_mask[idx].unsqueeze(1)).mean(0)

            sup_con_loss = self.sup_loss(centroids, large=True)

        output = self.classifier3(output_, edge_index, edge_weight)

        if 'OGBN' in self.args.dataset:
            labels = labels.squeeze(1)
        
        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])
        
        return loss_nodeclassification, sup_con_loss


    def sup_loss(self, features, labels=None, mask=None, contrast_mode='all', temp=0.07, base_temp=0.07, weight_mask=None, large=False):
        """Compute loss for model. If both `labels` and `mask` are None,
        it degenerates to SimCLR unsupervised loss:
        https://arxiv.org/pdf/2002.05709.pdf
        Args:
            features: hidden vector of shape [bsz, n_views, ...].
            labels: ground truth of shape [bsz].
            mask: contrastive mask of shape [bsz, bsz], mask_{i,j}=1 if sample j
                has the same class as sample i. Can be asymmetric.
        Returns:
            A loss scalar.
        """
        # if len(features.shape) < 3:
        #     raise ValueError('`features` needs to be [bsz, n_views, ...],'
        #                      'at least 3 dimensions are required')
        # if len(features.shape) > 3:
        #     features = features.view(features.shape[0], features.shape[1], -1)
        features = F.normalize(features, dim=-1)
        features = features.unsqueeze(1)
        batch_size = features.shape[0]

        if large:
            mask = torch.eye(batch_size, dtype=torch.float32).to(self.args.device)
            weight_mask = torch.ones(batch_size).to(self.args.device)
        else:
            weight_mask = weight_mask.to(self.args.device)
            if labels is not None and mask is not None:
                raise ValueError('Cannot define both `labels` and `mask`')
            elif labels is None and mask is None:
                mask = torch.eye(batch_size, dtype=torch.float32)
            elif labels is not None:
                labels = labels.contiguous().view(-1, 1)
                if labels.shape[0] != batch_size:
                    raise ValueError('Num of labels does not match num of features')
                mask = torch.eq(labels, labels.T).float()
                # neg_mask = torch.where(mask == 1, 0, 1)
            else:
                mask = mask.float()

        contrast_count = features.shape[1]
        contrast_feature = torch.cat(torch.unbind(features, dim=1), dim=0)
        if contrast_mode == 'one':
            anchor_feature = features[:, 0]
            anchor_count = 1
        elif contrast_mode == 'all':
            anchor_feature = contrast_feature
            anchor_count = contrast_count
        else:
            raise ValueError('Unknown mode: {}'.format(self.contrast_mode))

        # compute logits
        anchor_dot_contrast = torch.div(
            torch.matmul(anchor_feature, contrast_feature.T),
            self.args.temp)
        # for numerical stability
        logits_max, _ = torch.max(anchor_dot_contrast, dim=1, keepdim=True)
        logits = anchor_dot_contrast - logits_max.detach()

        # tile mask
        mask = mask.repeat(anchor_count, contrast_count)
        # mask-out self-contrast cases
        logits_mask = torch.scatter(
            torch.ones_like(mask),
            1,
            torch.arange(batch_size * anchor_count).view(-1, 1).to(self.args.device),
            0
        )
        mask = mask * logits_mask

        # compute log_prob
        exp_logits = torch.exp(logits) * logits_mask 
        log_prob = logits - torch.log(exp_logits.sum(1, keepdim=True))
        # log_prob = torch.log(weight_mask * torch.exp(logits)) - torch.log(exp_logits.sum(1, keepdim=True))
        # log_prob = weight_mask * logits - torch.log(exp_logits.sum(1, keepdim=True))

        # compute mean of log-likelihood over positive
        if large:
            mean_log_prob_pos = log_prob.sum(1)
            # loss
            loss = - (temp / base_temp) * mean_log_prob_pos
            loss = loss.mean()
        else:
            row_mask = mask.sum(1) != 0
            mean_log_prob_pos = (weight_mask[row_mask] * mask[row_mask] * log_prob[row_mask]).sum(1) / mask[row_mask].sum(1)
            # loss
            loss = - (temp / base_temp) * mean_log_prob_pos
            loss = loss.view(anchor_count, sum(row_mask).item()).mean()

        return loss