from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from tqdm import trange
from layers import GCN, GAT, SAGE, SGC
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj

from sklearn.decomposition import PCA

class PPL():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)


            # Obtain Pseudo Labels
            lp_model = LabelPropagation(num_layers=50, alpha=self.args.lp_alpha)
            lp_output = lp_model(y=self.labels, edge_index=self.edge_index, mask=self.train_mask)
            self.pseudo_labels = lp_output.argmax(1)

            # Leveraging partial labels
            self.edge_weight = None
            edge_weight = None
            self.x = torch.nan_to_num(self.x, 0)

            # # DADX -> PCA
            pca = PCA(n_components=self.args.n_hid)
            self.x = torch.FloatTensor(pca.fit_transform(self.x.cpu())).to(self.args.device)
            
            # for i in range(40):
            #     tmp_edge_index, tmp_DAD = utils.get_symmetrically_normalized_adjacency(self.edge_index, self.x.shape[0])
            #     tmp_adj = to_dense_adj(tmp_edge_index, edge_attr=tmp_DAD)[0]
            #     self.x = torch.mm(tmp_adj, self.x)            
            
            sim = F.normalize(self.x) @ F.normalize(self.x.T)
            # # sim = F.normalize(self.x @ self.x.T)
            edge_weight = self.adj * sim
            # edge_weight = F.normalize(self.adj * sim)
            # edge_weight = F.normalize(self.adj) + F.normalize(self.adj * sim)
            # self.edge_index, self.edge_weight = edge_weight.to_sparse().indices(), edge_weight.to_sparse().values()
            

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)

            acc_vals = []
            test_results = []
            best_metric = 0

            # pca_x = self.x

            for epoch in range(0, self.args.epochs):
                model.train()
                optimizer.zero_grad()

                loss = model(lp_output, self.edge_index, self.edge_weight, self.labels, self.train_mask)
                # loss = model(lp_output, self.edge_index, self.edge_weight, pca_x, self.pseudo_labels, torch.where(self.train_mask, True, True))

                # loss = model(lp_output, self.edge_index, self.pseudo_labels, torch.where(self.train_mask, True, True))

                loss.backward()
                optimizer.step()

                # Valid
                model.eval()
                output = model.classifier(lp_output, self.edge_index, self.edge_weight)
                # output = torch.mm(embed+pca_x, model.classifier.conv1[0].lin.weight)
                
                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid')

                acc_vals.append(acc_val)

                if best_metric <= acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test')

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    st = "[seed {}][{}-{}][{}-{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, self.args.filling_method, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test')
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break

            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info(self.args)
        logger.info(f'=================================')

        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            classifier = GCN(args.n_layer, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=True)
            # classifier = GCN(args.n_layer, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False)
        elif args.gnn == "SAGE":
            classifier = SAGE(args.n_layer, args.n_feat, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        self.classifier = classifier

    def forward(self, x, edge_index, edge_weight, labels, idx_train):
        output = self.classifier(x, edge_index, edge_weight)
        # output = torch.mm(F.normalize(embed)+F.normalize(pca_x), self.classifier.conv1[0].lin.weight)

        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])

        return loss_nodeclassification