from embedder import embedder
import torch
import torch.nn as nn
import torch.optim as optim
import torch.nn.functional as F
import numpy as np
from copy import deepcopy
import datetime
import utils
from tqdm import trange
from layers import GCN, GAT, SAGE, SGC, MLP
from torch_geometric.nn.models import LabelPropagation
from torch_geometric.utils import to_dense_adj
from torch_geometric.nn.inits import reset, glorot, zeros
from sklearn.decomposition import PCA
from filling_strategies import filling
import pickle

class PPL_contrastive():
    def __init__(self, args):
        self.args = args
    
    def training(self):
        file = utils.set_filename(self.args)
        logger = utils.setup_logger('./', '-', file)

        seed_result = {}
        seed_result['acc'] = []
        seed_result['macro_F'] = []
        
        for seed in trange(0, 0+self.args.n_runs):
            print(f'============== seed:{seed} ==============')
            utils.seed_everything(seed)
            print('seed:', seed, file)
            self.args.seed = seed
            self = embedder(self.args, seed)
            # self.adj = self.adj.to(self.args.device)

            # adj_ = self.adj * prediction_matrix
            # tmp_edge_index = adj_.to_sparse().indices().to(self.args.device)
            
            tmp_edge_index = self.edge_index
            filled_features_zero = filling('zero', tmp_edge_index, self.x, self.missing_feature_mask, self.args.hop, self.args.replace, self.args.num_iterations, self.args.normalize_feature)
            filled_features_fp = filling('fp', tmp_edge_index, self.x, self.missing_feature_mask, self.args.hop, self.args.replace, self.args.num_iterations, self.args.normalize_feature)
            self.x_zero = torch.where(self.missing_feature_mask, self.x, filled_features_zero)
            self.x = torch.where(self.missing_feature_mask, self.x, filled_features_fp)


            with open('x_zero.pickle', 'wb') as f:
                pickle.dump(self.x_zero, f)      
            with open('x_fp.pickle', 'wb') as f:
                pickle.dump(self.x, f) 

            # Obtain Pseudo Labels
            lp_model = LabelPropagation(num_layers=50, alpha=self.args.lp_alpha)
            lp_output = lp_model(y=self.labels, edge_index=self.edge_index, mask=self.train_mask)
            self.pseudo_labels = lp_output.argmax(1)
            pseudo_pos_mask = []
            pseudo_neg_mask = []

            for i in range(len(self.pseudo_labels)):
                neighbor_idx = self.adj[i].nonzero()
                homo_or_not = len(self.pseudo_labels[neighbor_idx].unique())

                if homo_or_not == 1:
                    pseudo_pos_mask.append(True)
                    pseudo_neg_mask.append(False)
                else:
                    pseudo_pos_mask.append(False)
                    pseudo_neg_mask.append(True)

            # Obtain Mask for Contrastive Loss
            # one_hot = torch.FloatTensor(torch.nn.functional.one_hot(self.pseudo_labels.cpu()) + 0.0)
            # prediction_matrix = torch.mm(one_hot, one_hot.T).to(self.args.device)
            
            # gt_idx = self.train_mask
            # pseudo_idx = ~self.train_mask
            # strong_mat = gt_idx.unsqueeze(1).float() @ gt_idx.unsqueeze(1).T.float()
            # neutral_mat = gt_idx.unsqueeze(1).float() @ pseudo_idx.unsqueeze(1).T.float()
            # weak_mat = pseudo_idx.unsqueeze(1).float() @ pseudo_idx.unsqueeze(1).T.float()

            # mask['SP'] = strong_mat * prediction_matrix
            # mask['NP'] = neutral_mat * prediction_matrix
            # mask['WP'] = weak_mat * prediction_matrix

            # mask['SN'] = strong_mat * torch.where(prediction_matrix == 1, 0.0, 1.0)
            # mask['NN'] = neutral_mat * torch.where(prediction_matrix == 1, 0.0, 1.0)
            # mask['WN'] = weak_mat * torch.where(prediction_matrix == 1, 0.0, 1.0)

            # _positive = embed[triplet_mask[i][1]]
            # positive_val = lp_output[triplet_mask[i][1]].max(1).values
            # positive = _positive[torch.sort(positive_val, descending=True).indices]

            mask = {}
            for i in range(self.args.n_class):
                mask[i] = {}
                base = torch.zeros(len(self.train_mask)) == -1
                _query = torch.logical_and(self.train_mask, self.labels == i)
                _pseudo = torch.logical_and(self.pseudo_labels == i, ~self.train_mask)
                query_idx = _query.nonzero().squeeze()
                pseudo_idx = _pseudo.nonzero().squeeze()
                pseudo_pos = (self.pseudo_labels == i) * torch.tensor(pseudo_pos_mask).to(self.args.device)
                pseudo_neg = (self.pseudo_labels == i) * torch.tensor(pseudo_neg_mask).to(self.args.device)

                # Strong
                query_indices = torch.randperm(len(query_idx))
                query_idx_strong = query_idx[query_indices][:int(len(query_idx)/2)]
                positive_idx_strong = query_idx[query_indices][int(len(query_idx)/2):]

                query = deepcopy(_query)
                positive = deepcopy(_query)
                
                query[query_idx_strong] = False
                positive[positive_idx_strong] = False

                strong_query = query
                strong_positive = positive
                strong_negative = torch.logical_and(self.train_mask, self.labels != i) # others exist !

                mask[i]['strong'] = [strong_query, strong_positive, strong_negative]

                # Neutral
                pseudo_indices = torch.randperm(len(pseudo_idx))
                postivie_idx_neutral = pseudo_idx[pseudo_indices][:len(query_idx)] # design choice - all or half

                pseudo_positive = deepcopy(base)
                pseudo_positive[postivie_idx_neutral] = True
                
                neutral_query = deepcopy(_query)
                neutral_positive = pseudo_positive.to(self.args.device)
                # neutral_negative = torch.logical_and(self.pseudo_labels != i, ~self.train_mask) # others exist !
                # neutral_negative = torch.logical_and(self.train_mask, self.labels != i) 
                # neutral_negative = torch.logical_and(~self.train_mask, self.pseudo_labels != i) # big gap!!!
                neutral_negative = torch.logical_and(~self.train_mask, pseudo_neg * self.pseudo_labels != i) # 

                mask[i]['neutral'] = [neutral_query, neutral_positive, neutral_negative]

                # Weak
                remaining_indices = len(pseudo_idx) - len(query_idx)
                anchor_idx_weak = pseudo_idx[pseudo_indices][len(query_idx):len(query_idx)+int(remaining_indices/2)]
                postivie_idx_weak = pseudo_idx[pseudo_indices][len(query_idx)+int(remaining_indices/2):len(query_idx)+ 2 * int(remaining_indices/2)]
                                
                __pseudo_anchor = deepcopy(base)
                __pseudo_positive = deepcopy(base)

                __pseudo_anchor[anchor_idx_weak] = True
                __pseudo_positive[postivie_idx_weak] = True

                weak_query = __pseudo_anchor.to(self.args.device)
                weak_positive = __pseudo_positive.to(self.args.device)
                weak_negative = torch.logical_and(~self.train_mask, pseudo_neg * self.pseudo_labels != i) # 

                mask[i]['weak'] = [weak_query, weak_positive, weak_negative]


            # Leveraging partial labels
            self.edge_weight = None
            edge_weight = None
            self.x = torch.nan_to_num(self.x, 0)

            # Main training
            model = modeler(self.args).to(self.args.device)
            optimizer = optim.Adam(model.parameters(), lr=self.args.lr)

            acc_vals = []
            test_results = []
            best_metric = 0

            # pca_x = self.x

            for epoch in range(0, self.args.epochs):
                model.train()
                optimizer.zero_grad()

                loss = model(self.x, lp_output, self.edge_index, self.edge_weight, self.labels, self.pseudo_labels, self.train_mask, mask)
                # loss = model(lp_output, self.edge_index, self.edge_weight, pca_x, self.pseudo_labels, torch.where(self.train_mask, True, True))

                # loss = model(lp_output, self.edge_index, self.pseudo_labels, torch.where(self.train_mask, True, True))

                loss.backward()
                optimizer.step()

                # Valid
                model.eval()

                fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)
                        
                fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)

                output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64
                
                # output = model.classifier2(output_, self.edge_index, self.edge_weight, transpose=True)
                output = model.classifier3(output_, self.edge_index, self.edge_weight)
                # lp_output = output.detach()

                acc_val, macro_F_val = utils.performance(output[self.val_mask], self.labels[self.val_mask], pre='valid', evaluator=self.evaluator)

                acc_vals.append(acc_val)

                if best_metric <= acc_val:
                    best_metric = acc_val
                    max_idx = acc_vals.index(max(acc_vals))
                    best_output = output[:]
                    # best_model = deepcopy(model)

                # Test
                acc_test, macro_F_test = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)

                test_results.append([acc_test, macro_F_test])
                best_test_result = test_results[max_idx]

                if epoch % self.args.print_result == 0:
                    st = "[seed {}][{}-{}][{}][Epoch {}]".format(seed, self.args.dataset, self.args.missing_rate, self.args.embedder, epoch)
                    st += "[Val] ACC: {:.2f}, Macro-F1: {:.2f}|| ".format(acc_val, macro_F_val)
                    st += "[Test] ACC: {:.2f}, Macro-F1: {:.2f}\n".format(acc_test, macro_F_test)
                    st += "  [*Best Test Result*][Epoch {}] ACC: {:.2f}, Macro-F1: {:.2f}".format(max_idx, best_test_result[0], best_test_result[1])
                    print(st)
                      
                if (epoch - max_idx > self.args.patience) or (epoch+1 == self.args.epochs):
                    if epoch - max_idx > self.args.patience:
                        print("Early stop")
                        # model = best_model
                        # fp_embed = model.classifier1(self.x, self.edge_index, self.edge_weight, embed=True)
                        # lp_embed = model.classifier2(lp_output, self.edge_index, self.edge_weight, embed=True)
                                
                        # fp_ = model.leakyrelu(torch.mm(fp_embed, model.attention))
                        # lp_ = model.leakyrelu(torch.mm(lp_embed, model.attention))
                        # values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)

                        # output_ = (values[:,0].unsqueeze(1) * fp_embed) + (values[:,1].unsqueeze(1) * lp_embed) # 86 x 64
                    
                    output = best_output
                    best_test_result[0], best_test_result[1] = utils.performance(output[self.test_mask], self.labels[self.test_mask], pre='test', evaluator=self.evaluator)
                    print("[Best Test Result] ACC: {:.2f}, Macro-F1: {:.2f}".format(best_test_result[0], best_test_result[1]))
                    break
            seed_result['acc'].append(float(best_test_result[0]))
            seed_result['macro_F'].append(float(best_test_result[1]))

        acc = seed_result['acc']
        f1 = seed_result['macro_F']

        print('[Averaged result] ACC: {:.2f}+{:.2f}, Macro-F: {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        print('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))

        logger.info('')
        logger.info(datetime.datetime.now())
        logger.info(file)
        logger.info(f'----------- missing rate: {self.args.missing_rate} -----------')
        logger.info('{:.2f}+{:.2f} {:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc), np.mean(f1), np.std(f1)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(acc), np.std(acc)))
        logger.info('{:.2f}+{:.2f}'.format(np.mean(f1), np.std(f1)))
        logger.info(self.args)
        logger.info(f'=================================')

        # print(self.args)


class modeler(nn.Module):
    def __init__(self, args):
        super(modeler, self).__init__()
        self.args = args
    
        ## Model Selection ##
        if args.gnn == 'GCN':
            classifier1 = GCN(1, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False)
            classifier2 = GCN(1, args.n_class, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=True)
            classifier3 = GCN(1, args.n_hid, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False, transpose=False, classifier=True)
            # classifier3 = MLP(num_features=args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm, classifier=True)

            # classifier3 = MLP(num_features=args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm)
            # classifier2 = MLP(num_features=2 * args.n_hid, hidden_dim=args.n_hid, num_classes=args.n_class, num_layers=1, dropout=self.args.dropout, batch_norm=self.args.batch_norm)
            # classifier = GCN(args.n_layer, args.n_feat, args.n_hid, args.n_class, normalize=True, is_add_self_loops=False)
        elif args.gnn == 'GAT':
            classifier = GAT(args.n_layer, args.n_feat, args.n_hid, args.n_class, args.n_head, is_add_self_loops=False)
        elif args.gnn == "SAGE":
            classifier = SAGE(args.n_layer, args.n_feat, args.n_hid, args.n_class)
        elif args.gnn == "SGC":
            classifier = SGC(args.n_feat, args.n_class, args.n_layer, is_add_self_loops=False)
        else:
            raise NotImplementedError("Not Implemented Architecture!")        
        self.classifier1 = classifier1
        self.classifier2 = classifier2
        self.classifier3 = classifier3
        self.triplet_loss = torch.nn.TripletMarginLoss(margin=1.0, p=2)
        self.leakyrelu = nn.LeakyReLU(args.leaky_alpha)
        self.attention = nn.Parameter(torch.empty(size=(args.n_hid, 1)))
        glorot(self.attention)
        #self.q = model.Attention(args.nclass, 1)

    def forward(self, x, lp_embed, edge_index, edge_weight, labels, pseudo_labels, idx_train, mask=None):
        _fp_embed = self.classifier1(x, edge_index, edge_weight, embed=True)
        _lp_embed = self.classifier2(lp_embed, edge_index, edge_weight, embed=True)

        fp_ = self.leakyrelu(torch.mm(_fp_embed, self.attention))
        lp_ = self.leakyrelu(torch.mm(_lp_embed, self.attention))
        values = torch.softmax(torch.cat((fp_, lp_), dim=1), dim=1)
        output_ = (values[:,0].unsqueeze(1) * _fp_embed) + (values[:,1].unsqueeze(1) * _lp_embed) # 86 x 64
        
        loss_nce = 0
        for i in range(self.args.n_class):
            for key in ['strong', 'neutral', 'weak']:
            # for key in ['strong']:
            # for key in ['strong']:
                anch, pos, neg = mask[i][key]
                if key == 'strong':
                    temp = 0.1
                elif key == 'neutral':
                    temp = 0.01
                elif key == 'weak':
                    temp = 0.001 # lower temp punsigh more on hard negative samples
                loss_tmp = self.info_nce_loss(output_[anch], output_[pos], output_[neg], 0.1)
                loss_nce += loss_tmp

        #output = self.classifier2(output_, edge_index, edge_weight, transpose=True)
        output = self.classifier3(output_, edge_index, edge_weight)
        
        if 'OGBN' in self.args.dataset:
            labels = labels.squeeze(1)
        
        loss_nodeclassification = F.cross_entropy(output[idx_train], labels[idx_train])
        
        # return loss_nodeclassification + loss_nce
        return loss_nodeclassification + loss_nce

    def info_nce_loss(self, query, positive_key, negative_keys=None, temperature=0.1, reduction='mean', negative_mode='unpaired'):
        # Normalize to unit vectors
        query, positive_key, negative_keys = self.normalize(query, positive_key, negative_keys)
        if negative_keys is not None:
            # Explicit negative keys

            # Cosine between positive pairs
            positive_logit = torch.sum(query[:len(positive_key)] * positive_key, dim=1, keepdim=True)

            if negative_mode == 'unpaired':
                # Cosine between all query-negative combinations
                negative_logits = query[:len(positive_key)] @ self.transpose(negative_keys[:len(positive_logit)])

            elif negative_mode == 'paired':
                query = query.unsqueeze(1)
                negative_logits = query @ self.transpose(negative_keys)
                negative_logits = negative_logits.squeeze(1)

            # First index in last dimension are the positive samples
            logits = torch.cat([positive_logit, negative_logits], dim=1)
            labels = torch.zeros(len(logits), dtype=torch.long, device=query.device)
        else:
            # Negative keys are implicitly off-diagonal positive keys.

            # Cosine between all combinations
            logits = query @ self.transpose(positive_key)

            # Positive keys are the entries on the diagonal
            labels = torch.arange(len(query), device=query.device)

        return F.cross_entropy(logits / temperature, labels, reduction=reduction)


    def transpose(self, x):
        return x.transpose(-2, -1)


    def normalize(self, *xs):
        return [None if x is None else F.normalize(x, dim=-1) for x in xs]


    def metric_learning(self, embed, lp_output, triplet_mask):
        loss_metric = 0
        for i in range(len(triplet_mask)):
            anchor = embed[triplet_mask[i][0]]
            # positive = embed[triplet_mask[i][1]]
            # negative = embed[triplet_mask[i][2]]

            ## pos: shuffling neg: shuffling
            if self.args.metric == 'shu-shu':
                _positive = embed[triplet_mask[i][1]]
                positive = _positive[torch.randperm(_positive.size()[0])]

                _negative = embed[triplet_mask[i][2]]
                negative = _negative[torch.randperm(_negative.size()[0])]
            
            ## pos: re-ordering neg: shuffling
            elif self.args.metric == 're-shu' or self.args.metric == 'gt':
                _positive = embed[triplet_mask[i][1]]
                positive_val = lp_output[triplet_mask[i][1]].max(1).values
                positive = _positive[torch.sort(positive_val, descending=True).indices]
                
                _negative = embed[triplet_mask[i][2]]
                negative = _negative[torch.randperm(_negative.size()[0])]

            ## pos: re-ordering neg: re-ordering (worst)
            elif self.args.metric == 're-re':
                _positive = embed[triplet_mask[i][1]]
                positive_val = lp_output[triplet_mask[i][1]].max(1).values
                positive = _positive[torch.sort(positive_val, descending=True).indices]
                
                _negative = embed[triplet_mask[i][2]]
                negative_val = lp_output[triplet_mask[i][2]].max(1).values
                negative = _negative[torch.sort(negative_val, descending=False).indices]

            # num_sample = min(num_anchor, len(positive), len(negative))
            num_sample = min(positive.shape[0], negative.shape[0])
            num_anchor = len(anchor)
            num_batch = int(num_sample/num_anchor)
            tmp_loss = 0
            for i in range(num_batch):
                _loss = self.triplet_loss(anchor, positive[(i)*num_anchor:(i+1)*num_anchor], negative[(i)*num_anchor:(i+1)*num_anchor])
                tmp_loss += _loss
            
            # loss_metric += tmp_loss
            loss_metric += (tmp_loss / num_batch)

        return loss_metric / len(triplet_mask)