#!/bin/bash
export datasets="Cora Photo cs"
export datasets_="CiteSeer PubMed Computers physics wikics"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export embedders="Node2Vec Node2Vec_GNN"
export missing_rates_="1.0"
export embedders_="MLP GNN PaGNN GCNMF LP"
export embedders_="GNN"
export gpu=2

# Node2Vec without x
for data in $datasets
do
for embedder in $embedders
do
python main.py --dataset ${data} --missing_rate 0.0 --embedder ${embedder} --filling_method fp --coef_loss False --gpu ${gpu}
done
done

# 1.0 - Baseline
for data in $datasets
do
python main.py --dataset ${data} --missing_rate 1.0 --embedder MLP --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method zero --pca True --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder PaGNN --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GCNMF --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method neighborhood_mean --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method fp --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method fp --pca True --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder LP --filling_method zero --coef_loss False --gpu ${gpu}
done

# Node2Vec without x
for data in $datasets_
do
for embedder in $embedders
do
python main.py --dataset ${data} --missing_rate 0.0 --embedder ${embedder} --filling_method fp --coef_loss False --gpu ${gpu}
done
done

# 1.0 - Baseline
for data in $datasets_
do
python main.py --dataset ${data} --missing_rate 1.0 --embedder MLP --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method zero --pca True --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder PaGNN --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GCNMF --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method neighborhood_mean --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method fp --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder GNN --filling_method fp --pca True --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate 1.0 --embedder LP --filling_method zero --coef_loss False --gpu ${gpu}
done