#!/bin/bash
export datasets="physics"
# export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates="0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export embedders="MLP GNN"
export gpu=2


# Node2Vec without x
for data in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder MLP --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method zero --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method neighborhood_mean --coef_loss False --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method fp --coef_loss False --gpu ${gpu}
done
done