#!/bin/bash
export datasets="Cora"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export embedders="PPL"
export gpu=1


for data in "Cora"
do
for missing_rate in $missing_rates
do
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric shu-shu --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric re-shu --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric re-re --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric gt --gpu ${gpu}
done
done

for data in "cs"
do
for missing_rate in $missing_rates
do
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric shu-shu --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric re-shu --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric re-re --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PPL --filling_method fp --coef_loss False --metric gt --gpu ${gpu}
done
done