#!/bin/bash
export datasets="Computers cs physics wikics"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export gpu=2

for missing_rate in $missing_rates
do
python main.py --dataset Cora --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.99  --lamb 0.2 --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset CiteSeer --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.999 --lamb 0.2 --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset PubMed --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.999 --lamb 0.2 --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset Photo --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.9 --lamb 0.2 --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.99 --lamb 0.2 --n_runs 10 --filling_method fp --gpu ${gpu}
done

for missing_rate in $missing_rates
do
for lamb in $lambda_list
do
python main.py --dataset Cora --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.99 --lamb ${lamb} --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset CiteSeer --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset PubMed --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.999 --lamb ${lamb} --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset Photo --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.9 --lamb ${lamb} --n_runs 10 --filling_method fp --gpu ${gpu}
python main.py --dataset cs --missing_rate ${missing_rate} --embedder PPL_contrastive --lp_alpha 0.99 --lamb ${lamb} --n_runs 10 --filling_method fp --gpu ${gpu}
done
done
