#!/bin/bash
export datasets="PubMed"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list="0.0 0.1 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export gpu=3

for missing_rate in $missing_rates
do
python main.py --dataset PubMed --missing_rate ${missing_rate} --embedder GNN --filling_method zero --n_runs 10 --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset physics --missing_rate ${missing_rate} --embedder GNN --filling_method zero --n_runs 10 --gpu ${gpu}
done